<?php
include 'auth.php';
include 'db.php';
include 'adminhead.php';
include 'sidebar.php';

$success = '';
$error = '';

/* ===============================
   DELETE BRAND
================================ */
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM brands WHERE id=?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "<script>alert('Brand deleted!'); window.location='adminbrands.php';</script>";
        exit();
    } else {
        $error = "Delete failed: " . $stmt->error;
    }
}

/* ===============================
   ADD BRAND
================================ */
if (isset($_POST['add_brand'])) {

    $name = $_POST['name'];
    $category_id = intval($_POST['category_id']);

    $stmt = $conn->prepare("INSERT INTO brands (name, category_id) VALUES (?,?)");
    $stmt->bind_param("si", $name, $category_id);

    if ($stmt->execute()) {
        echo "<script>alert('Brand Added Successfully!'); window.location='adminbrands.php';</script>";
        exit();
    } else {
        $error = "Failed to add brand.";
    }
}

/* ===============================
   UPDATE BRAND
================================ */
if (isset($_POST['update_brand'])) {

    $id = intval($_POST['update_id']);
    $name = $_POST['name'];
    $category_id = intval($_POST['category_id']);

    $stmt = $conn->prepare("UPDATE brands SET name=?, category_id=? WHERE id=?");
    $stmt->bind_param("sii", $name, $category_id, $id);

    if ($stmt->execute()) {
        echo "<script>alert('Brand Updated!'); window.location='adminbrands.php';</script>";
        exit();
    } else {
        $error = "Update failed.";
    }
}

/* ===============================
   FETCH BRANDS & CATEGORIES
================================ */
$brand_result = $conn->query("
    SELECT brands.*, categories.name AS category_name 
    FROM brands 
    LEFT JOIN categories 
    ON brands.category_id = categories.id 
    ORDER BY brands.id DESC
");

$categories = $conn->query("SELECT * FROM categories ORDER BY name ASC");
?>

<div class="container-fluid pt-4 px-4">
    <div class="bg-secondary text-light rounded p-4">

        <h4 class="text-center mb-4">Manage Brands</h4>

        <!-- Add Brand Form -->
        <form method="post" class="mb-4 text-start">

            <h5>Add Brand</h5><hr class="border-light">

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Brand Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Select Category</label>
                    <select name="category_id" class="form-control" required>
                        <option value="">Select Category</option>
                        <?php while($cat = $categories->fetch_assoc()): ?>
                            <option value="<?= $cat['id']; ?>"><?= $cat['name']; ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </div>

            <button type="submit" name="add_brand" class="btn btn-primary">Add Brand</button>
        </form>


        <!-- Brand Table -->
        <div class="table-responsive mt-4">
            <table class="table text-start align-middle table-bordered table-hover mb-0">
                <thead>
                    <tr class="text-white">
                        <th>#</th>
                        <th>Brand Name</th>
                        <th>Category</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $i=1; while ($row = $brand_result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++; ?></td>
                        <td><?= htmlspecialchars($row['name']); ?></td>
                        <td><?= $row['category_name'] ? $row['category_name'] : 'Uncategorized'; ?></td>

                        <td>
                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal"
                                data-bs-target="#editModal<?= $row['id']; ?>">Edit</button>

                            <a onclick="return confirm('Delete brand?')"
                                href="adminbrands.php?delete=<?= $row['id']; ?>"
                                class="btn btn-sm btn-primary">
                                Delete
                            </a>
                        </td>
                    </tr>

                    <!-- EDIT MODAL -->
                    <div class="modal fade" id="editModal<?= $row['id']; ?>" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content bg-dark text-white">

                                <form method="post">

                                    <div class="modal-header">
                                        <h5>Edit Brand #<?= $row['id']; ?></h5>
                                        <button type="button" class="btn-close bg-white" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">

                                        <input type="hidden" name="update_id" value="<?= $row['id']; ?>">

                                        <div class="mb-3">
                                            <label>Brand Name</label>
                                            <input type="text" name="name" class="form-control"
                                                   value="<?= htmlspecialchars($row['name']); ?>" required>
                                        </div>

                                        <div class="mb-3">
                                            <label>Select Category</label>
                                            <select name="category_id" class="form-control" required>
                                                <?php  
                                                $cat2 = $conn->query("SELECT * FROM categories ORDER BY name ASC");
                                                while($c = $cat2->fetch_assoc()): ?>
                                                    <option value="<?= $c['id']; ?>"
                                                        <?= ($row['category_id']==$c['id'])?"selected":""; ?>>
                                                        <?= $c['name']; ?>
                                                    </option>
                                                <?php endwhile; ?>
                                            </select>
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <button type="submit" name="update_brand" class="btn btn-success">Save Changes</button>
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- END EDIT MODAL -->

                    <?php endwhile; ?>
                </tbody>

            </table>
        </div>

    </div>
</div>

<?php include 'adminfoot.php'; ?>
