<?php
include 'auth.php';
include 'db.php';
include 'adminhead.php';
include 'sidebar.php';

$success = '';
$error = '';

/* ===============================
   DELETE JOB
================================ */
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM jobs WHERE id=?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "<script>alert('Job deleted successfully!'); window.location='admincareer.php';</script>";
        exit();
    } else {
        $error = "Failed to delete job: " . $stmt->error;
    }
}

/* ===============================
   ADD JOB
================================ */
if (isset($_POST['add_job'])) {

    $title       = $_POST['title'];
    $department  = $_POST['department'];
    $location    = $_POST['location'];
    $type        = $_POST['type'];
    $description = $_POST['description'];

    $stmt = $conn->prepare("INSERT INTO jobs (title, department, location, type, description) VALUES (?,?,?,?,?)");
    $stmt->bind_param("sssss", $title, $department, $location, $type, $description);

    if ($stmt->execute()) {
        echo "<script>alert('Job Added Successfully!'); window.location='admincareer.php';</script>";
        exit();
    } else {
        $error = "Failed to add job.";
    }
}

/* ===============================
   UPDATE JOB
================================ */
if (isset($_POST['update_job'])) {

    $id          = intval($_POST['update_id']);
    $title       = $_POST['title'];
    $department  = $_POST['department'];
    $location    = $_POST['location'];
    $type        = $_POST['type'];
    $description = $_POST['description'];

    $stmt = $conn->prepare("UPDATE jobs SET title=?, department=?, location=?, type=?, description=? WHERE id=?");
    $stmt->bind_param("sssssi", $title, $department, $location, $type, $description, $id);

    if ($stmt->execute()) {
        echo "<script>alert('Job Updated Successfully!'); window.location='admincareer.php';</script>";
        exit();
    } else {
        $error = "Failed to update job.";
    }
}

/* ===============================
   FETCH JOBS
================================ */
$result = $conn->query("SELECT * FROM jobs ORDER BY id DESC");
?>

<!-- Job Management Start -->
<div class="container-fluid pt-4 px-4">
    <div class="bg-secondary text-light rounded p-4">

        <h4 class="text-center mb-4">Manage Career Listings</h4>

        <!-- Add Job Form -->
        <form method="post" class="mb-4 text-start">

            <h5>Add New Job</h5><hr class="border-light">

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Job Title</label>
                    <input type="text" name="title" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Department</label>
                    <input type="text" name="department" class="form-control" required>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Location</label>
                    <input type="text" name="location" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Job Type</label>
                    <select name="type" class="form-control">
                        <option>Full-Time</option>
                        <option>Part-Time</option>
                        <option>Internship</option>
                    </select>
                </div>
            </div>

            <div class="mb-3">
                <label>Description</label>
                <textarea name="description" rows="4" class="form-control" required></textarea>
            </div>

            <button type="submit" name="add_job" class="btn btn-primary">Add Job</button>
        </form>


        <!-- Jobs Table -->
        <div class="table-responsive mt-4">
            <table class="table text-start align-middle table-bordered table-hover mb-0">
                <thead>
                    <tr class="text-white">
                        <th>#</th>
                        <th>Title</th>
                        <th>Dept</th>
                        <th>Location</th>
                        <th>Type</th>
                        <th>Description</th>
                        <th>Posted</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php 
                    $i = 1;
                    while ($row = $result->fetch_assoc()): 
                    ?>
                    <tr>
                        <td><?= $i++; ?></td>
                        <td><?= htmlspecialchars($row['title']); ?></td>
                        <td><?= htmlspecialchars($row['department']); ?></td>
                        <td><?= htmlspecialchars($row['location']); ?></td>
                        <td><?= htmlspecialchars($row['type']); ?></td>

                        <td><?= substr($row['description'], 0, 60); ?>...</td>

                        <td><?= date("d M Y", strtotime($row['posted_on'])); ?></td>

                        <td>
                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal"
                                data-bs-target="#editModal<?= $row['id']; ?>">Edit</button>

                            <a onclick="return confirm('Delete this job?')"
                                href="admincareer.php?delete=<?= $row['id']; ?>"
                                class="btn btn-sm btn-primary">
                                Delete
                            </a>
                        </td>
                    </tr>

                    <!-- EDIT MODAL -->
                    <div class="modal fade" id="editModal<?= $row['id']; ?>" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content bg-dark text-white">

                                <form method="post">

                                    <div class="modal-header">
                                        <h5>Edit Job #<?= $row['id']; ?></h5>
                                        <button type="button" class="btn-close bg-white" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">

                                        <input type="hidden" name="update_id" value="<?= $row['id']; ?>">

                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label>Job Title</label>
                                                <input type="text" name="title" class="form-control"
                                                       value="<?= htmlspecialchars($row['title']); ?>" required>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label>Department</label>
                                                <input type="text" name="department" class="form-control"
                                                       value="<?= htmlspecialchars($row['department']); ?>" required>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label>Location</label>
                                                <input type="text" name="location" class="form-control"
                                                       value="<?= htmlspecialchars($row['location']); ?>" required>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label>Job Type</label>
                                                <select name="type" class="form-control">
                                                    <option <?= ($row['type']=="Full-Time")?"selected":""; ?>>Full-Time</option>
                                                    <option <?= ($row['type']=="Part-Time")?"selected":""; ?>>Part-Time</option>
                                                    <option <?= ($row['type']=="Internship")?"selected":""; ?>>Internship</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="mb-3">
                                            <label>Description</label>
                                            <textarea name="description" class="form-control" rows="4"><?= htmlspecialchars($row['description']); ?></textarea>
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <button type="submit" name="update_job" class="btn btn-success">Save Changes</button>
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- END EDIT MODAL -->

                    <?php endwhile; ?>
                </tbody>

            </table>
        </div>

    </div>
</div>
<!-- Job Management End -->

<?php include 'adminfoot.php'; ?>
