<?php
include 'auth.php';
include 'db.php';
include 'adminhead.php';
include 'sidebar.php';

$success = '';
$error = '';

/* ===============================
   DELETE CATEGORY
================================ */
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM categories WHERE id=?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "<script>alert('Category deleted!'); window.location='admincategories.php';</script>";
        exit();
    } else {
        $error = "Delete failed: " . $stmt->error;
    }
}

/* ===============================
   ADD CATEGORY
================================ */
if (isset($_POST['add_category'])) {

    $name = $_POST['name'];
    $description = $_POST['description'];

    $stmt = $conn->prepare("INSERT INTO categories (name, description) VALUES (?,?)");
    $stmt->bind_param("ss", $name, $description);

    if ($stmt->execute()) {
        echo "<script>alert('Category Added Successfully!'); window.location='admincategories.php';</script>";
        exit();
    } else {
        $error = "Failed to add category.";
    }
}

/* ===============================
   UPDATE CATEGORY
================================ */
if (isset($_POST['update_category'])) {

    $id = intval($_POST['update_id']);
    $name = $_POST['name'];
    $description = $_POST['description'];

    $stmt = $conn->prepare("UPDATE categories SET name=?, description=? WHERE id=?");
    $stmt->bind_param("ssi", $name, $description, $id);

    if ($stmt->execute()) {
        echo "<script>alert('Category Updated!'); window.location='admincategories.php';</script>";
        exit();
    } else {
        $error = "Update failed.";
    }
}

/* ===============================
   FETCH CATEGORIES
================================ */
$result = $conn->query("SELECT * FROM categories ORDER BY id DESC");
?>

<div class="container-fluid pt-4 px-4">
    <div class="bg-secondary text-light rounded p-4">

        <h4 class="text-center mb-4">Manage Categories</h4>

        <!-- Add Category Form -->
        <form method="post" class="mb-4 text-start">

            <h5>Add New Category</h5><hr class="border-light">

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Category Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Description</label>
                    <input type="text" name="description" class="form-control" required>
                </div>
            </div>

            <button type="submit" name="add_category" class="btn btn-primary">Add Category</button>
        </form>

        <!-- Categories Table -->
        <div class="table-responsive mt-4">
            <table class="table text-start align-middle table-bordered table-hover mb-0">
                <thead>
                    <tr class="text-white">
                        <th>#</th>
                        <th>Category Name</th>
                        <th>Description</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $i=1; while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++; ?></td>
                        <td><?= htmlspecialchars($row['name']); ?></td>
                        <td><?= htmlspecialchars($row['description']); ?></td>

                        <td>
                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal"
                                data-bs-target="#editModal<?= $row['id']; ?>">Edit</button>

                            <a onclick="return confirm('Delete category?')"
                                href="admincategories.php?delete=<?= $row['id']; ?>"
                                class="btn btn-sm btn-primary">
                                Delete
                            </a>
                        </td>
                    </tr>

                    <!-- EDIT MODAL -->
                    <div class="modal fade" id="editModal<?= $row['id']; ?>" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content bg-dark text-white">

                                <form method="post">

                                    <div class="modal-header">
                                        <h5>Edit Category #<?= $row['id']; ?></h5>
                                        <button type="button" class="btn-close bg-white" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">

                                        <input type="hidden" name="update_id" value="<?= $row['id']; ?>">

                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label>Category Name</label>
                                                <input type="text" name="name" class="form-control"
                                                    value="<?= htmlspecialchars($row['name']); ?>" required>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label>Description</label>
                                                <input type="text" name="description" class="form-control"
                                                    value="<?= htmlspecialchars($row['description']); ?>">
                                            </div>
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <button type="submit" name="update_category" class="btn btn-success">Save Changes</button>
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- END EDIT MODAL -->

                    <?php endwhile; ?>
                </tbody>

            </table>
        </div>

    </div>
</div>

<?php include 'adminfoot.php'; ?>
