<?php
include 'auth.php';
include 'db.php';
include 'adminhead.php';
include 'sidebar.php';

$success = '';
$error = '';

/* ===============================
   DELETE PARTNER
================================ */
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM partners WHERE id=?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "<script>alert('Partner deleted successfully!'); window.location='adminpartners.php';</script>";
        exit();
    } else {
        $error = "Failed to delete partner: " . $stmt->error;
    }
}

/* ===============================
   ADD PARTNER
================================ */
if (isset($_POST['add_partner'])) {

    $title = $_POST['title'];
    $link = $_POST['link'];

    // Image upload
    $brand_image = '';
    if (!empty($_FILES['brand_image']['name'])) {
        $file_name = time() . "_" . basename($_FILES["brand_image"]["name"]);
        $target = "assets/images/" . $file_name;

        if (move_uploaded_file($_FILES["brand_image"]["tmp_name"], $target)) {
            $brand_image = $target;
        }
    }

    $stmt = $conn->prepare("INSERT INTO partners (title, brand_image, link) VALUES (?,?,?)");
    $stmt->bind_param("sss", $title, $brand_image, $link);

    if ($stmt->execute()) {
        echo "<script>alert('Partner Added Successfully!'); window.location='adminpartners.php';</script>";
        exit();
    } else {
        $error = "Failed to add partner.";
    }
}

/* ===============================
   UPDATE PARTNER
================================ */
if (isset($_POST['update_partner'])) {

    $id = intval($_POST['update_id']);
    $title = $_POST['title'];
    $link = $_POST['link'];

    // Handle image update
    $brand_image = $_POST['old_image'];

    if (!empty($_FILES['brand_image']['name'])) {
        $file_name = time() . "_" . basename($_FILES["brand_image"]["name"]);
        $target = "assets/images/" . $file_name;

        if (move_uploaded_file($_FILES["brand_image"]["tmp_name"], $target)) {
            $brand_image = $target;
        }
    }

    $stmt = $conn->prepare("UPDATE partners SET title=?, brand_image=?, link=? WHERE id=?");
    $stmt->bind_param("sssi", $title, $brand_image, $link, $id);

    if ($stmt->execute()) {
        echo "<script>alert('Partner Updated Successfully!'); window.location='adminpartners.php';</script>";
        exit();
    } else {
        $error = "Failed to update partner.";
    }
}

/* ===============================
   FETCH PARTNERS
================================ */
$result = $conn->query("SELECT * FROM partners ORDER BY id DESC");
?>

<!-- Partner Management Start -->
<div class="container-fluid pt-4 px-4">
    <div class="bg-secondary text-light rounded p-4">

        <h4 class="text-center mb-4">Manage Partners / Brands</h4>

        <!-- Add Partner Form -->
        <form method="post" enctype="multipart/form-data" class="mb-4 text-start">
            <h5>Add New Partner</h5>
            <hr class="border-light">

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Partner Title</label>
                    <input type="text" name="title" class="form-control" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Partner Link (Optional)</label>
                    <input type="text" name="link" class="form-control" required>
                </div>
            </div>

            <div class="mb-3">
                <label>Partner Image</label>
                <input type="file" name="brand_image" class="form-control" required>
            </div>

            <button type="submit" name="add_partner" class="btn btn-primary">Add Partner</button>
        </form>

        <!-- Partners Table -->
        <div class="table-responsive mt-4">
            <table class="table text-start align-middle table-bordered table-hover mb-0">
                <thead>
                    <tr class="text-white">
                        <th>#</th>
                        <th>Image</th>
                        <th>Title</th>
                        <th>Link</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php 
                    $i = 1;
                    while ($row = $result->fetch_assoc()): 
                    ?>
                    <tr>
                        <td><?= $i++; ?></td>

                        <td>
                            <img src="<?= $row['brand_image']; ?>" width="80" height="40" style="object-fit:contain;">
                        </td>

                        <td><?= htmlspecialchars($row['title']); ?></td>

                        <td>
                            <?php if ($row['link']): ?>
                                <a href="<?= $row['link']; ?>" target="_blank" class="text-info">Visit</a>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>

                        <td>
                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal"
                                data-bs-target="#editModal<?= $row['id']; ?>">Edit</button>

                            <a onclick="return confirm('Delete this partner?')"
                               href="adminpartners.php?delete=<?= $row['id']; ?>"
                               class="btn btn-sm btn-primary">Delete</a>
                        </td>
                    </tr>

                    <!-- EDIT MODAL -->
                    <div class="modal fade" id="editModal<?= $row['id']; ?>" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content bg-dark text-white">

                                <form method="post" enctype="multipart/form-data">

                                    <div class="modal-header">
                                        <h5>Edit Partner #<?= $row['id']; ?></h5>
                                        <button type="button" class="btn-close bg-white" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">

                                        <input type="hidden" name="update_id" value="<?= $row['id']; ?>">
                                        <input type="hidden" name="old_image" value="<?= $row['brand_image']; ?>">

                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label>Partner Title</label>
                                                <input type="text" name="title" class="form-control"
                                                    value="<?= htmlspecialchars($row['title']); ?>" required>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label>Partner Link</label>
                                                <input type="text" name="link" class="form-control"
                                                    value="<?= htmlspecialchars($row['link']); ?>">
                                            </div>
                                        </div>

                                        <div class="mb-3">
                                            <label>Partner Image</label>
                                            <input type="file" name="brand_image" class="form-control">
                                            <br>
                                            <img src="<?= $row['brand_image']; ?>" width="100">
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <button type="submit" name="update_partner" class="btn btn-success">Save Changes</button>
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- END EDIT MODAL -->

                    <?php endwhile; ?>
                </tbody>

            </table>
        </div>

    </div>
</div>
<!-- Partner Management End -->

<?php include 'adminfoot.php'; ?>
