<?php
include 'auth.php';
include 'db.php';
include 'adminhead.php';
include 'sidebar.php';

$success = '';
$error = '';

/* ===============================
   DELETE PRODUCT
================================ */
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM products WHERE id=?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "<script>alert('Product deleted!'); window.location='adminproducts.php';</script>";
        exit();
    }
}

/* ===============================
   ADD PRODUCT
================================ */
if (isset($_POST['add_product'])) {

    $title = $_POST['title'];
    $colours = !empty($_POST['colours']) ? $_POST['colours'] : NULL;
    $size = !empty($_POST['size']) ? $_POST['size'] : NULL;
    $category_id = $_POST['category_id'];
    $brand_id = $_POST['brand_id'];

    $product_image = "";
    if (!empty($_FILES['product_image']['name'])) {

    $allowed_ext = ['jpg','jpeg','png','webp','jfif'];
    $ext = strtolower(pathinfo($_FILES['product_image']['name'], PATHINFO_EXTENSION));

    if (!in_array($ext, $allowed_ext)) {
        echo "<script>alert('Only JPG, JPEG, PNG, WEBP images are allowed.'); window.location='adminproducts.php';</script>";
        exit();
    }

    $product_image = time() . "_" . basename($_FILES['product_image']['name']);
    move_uploaded_file($_FILES['product_image']['tmp_name'], "assets/images/" . $product_image);
}


    $stmt = $conn->prepare(
        "INSERT INTO products (title, colours, size, category_id, brand_id, product_image)
         VALUES (?,?,?,?,?,?)"
    );
    $stmt->bind_param("sssiis", $title, $colours, $size, $category_id, $brand_id, $product_image);

    $stmt->execute();
    echo "<script>alert('Product Added'); window.location='adminproducts.php';</script>";
    exit();
}

/* ===============================
   UPDATE PRODUCT
================================ */
if (isset($_POST['update_product'])) {

    $id = $_POST['update_id'];
    $title = $_POST['title'];
    $colours = !empty($_POST['colours']) ? $_POST['colours'] : NULL;
    $size = !empty($_POST['size']) ? $_POST['size'] : NULL;
    $category_id = $_POST['category_id'];
    $brand_id = $_POST['brand_id'];

    $product_image = $_POST['old_image'];
    if (!empty($_FILES['product_image']['name'])) {
        $product_image = time() . "_" . basename($_FILES['product_image']['name']);
        move_uploaded_file($_FILES['product_image']['tmp_name'], "assets/images/" . $product_image);
    }

    $stmt = $conn->prepare(
        "UPDATE products SET title=?, colours=?, size=?, category_id=?, brand_id=?, product_image=? WHERE id=?"
    );
    $stmt->bind_param("sssissi", $title, $colours, $size, $category_id, $brand_id, $product_image, $id);

    $stmt->execute();
    echo "<script>alert('Product Updated'); window.location='adminproducts.php';</script>";
    exit();
}

/* ===============================
   LOAD CATEGORIES & BRANDS
================================ */
$categories = $conn->query("SELECT * FROM categories ORDER BY name ASC");
$brands = $conn->query("SELECT * FROM brands ORDER BY name ASC");

/* ===============================
   LOAD PRODUCTS
================================ */
$products = $conn->query(
    "SELECT products.*, categories.name AS category_name, brands.name AS brand_name 
     FROM products
     LEFT JOIN categories ON categories.id = products.category_id
     LEFT JOIN brands ON brands.id = products.brand_id
     ORDER BY products.id DESC"
);
?>

<style>
.hidden {
    display: none;
}
</style>

<div class="container-fluid pt-4 px-4">
    <div class="bg-secondary text-light rounded p-4">

        <h4 class="text-center mb-4">Manage Products</h4>

        <!-- FORM START -->
        <form method="post" enctype="multipart/form-data" class="text-start">

            <h5>Add Product</h5>
            <hr class="border-light">

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Category</label>
                    <select name="category_id" id="categorySelect" class="form-control" required>
                        <option value="">Select Category</option>
                        <?php
                        $categories->data_seek(0);
                        while ($cat = $categories->fetch_assoc()):
                        ?>
                        <option value="<?= $cat['id']; ?>"><?= $cat['name']; ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Brand</label>
                    <select name="brand_id" class="form-control" required>
                        <?php 
                        $brands->data_seek(0);
                        while ($br = $brands->fetch_assoc()): ?>
                        <option value="<?= $br['id']; ?>"><?= $br['name']; ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </div>

            <!-- TITLE -->
            <div class="mb-3 category-field category-tiles category-sanitary category-granite category-paints">
                <label>Product Title</label>
                <input type="text" name="title" class="form-control" required>
            </div>


            <!-- SIZE (Tiles Only) -->
            <div class="mb-3 category-field category-tiles category-granite">
                <label>Size</label>
                <input type="text" name="size" class="form-control">
            </div>

            <!-- COLOURS (Granite Only) -->
            <div class="mb-3 category-field category-granite">
                <label>Colours</label>
                <input type="text" name="colours" class="form-control">
            </div>

            <div class="mb-3 category-field category-tiles category-sanitary category-granite category-paints">
                <label>Product Image</label>
                <input type="file" name="product_image" class="form-control" accept="image/*">
            </div>

            <button type="submit" name="add_product" class="btn btn-primary">Add Product</button>

        </form>
        <!-- FORM END -->

        <hr>

        <!-- PRODUCT TABLE -->
        <table class="table table-bordered text-light">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Image</th>
                    <th>Brand</th>
                    <th>Category</th>
                    <th>Title</th>
                    <th>Colours</th>
                    <th>Size</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                <?php $i = 1; while ($row = $products->fetch_assoc()): ?>
                <tr>
                    <td><?= $i++; ?></td>
                    <td>
                        <?php if ($row['product_image']): ?>
                        <img src="assets/images/<?= $row['product_image']; ?>" width="50">
                        <?php else: ?> — <?php endif; ?>
                    </td>
                    <td><?= $row['brand_name'] ?: '—'; ?></td>
                    <td><?= $row['category_name']; ?></td>
                    <td><?= $row['title']; ?></td>
                    <td><?= $row['colours'] ?: '—'; ?></td>
                    <td><?= $row['size'] ?: '—'; ?></td>

                    <td>
                        <button class="btn btn-sm btn-warning" data-bs-toggle="modal"
                            data-bs-target="#editModal<?= $row['id']; ?>">Edit</button>

                        <a href="adminproducts.php?delete=<?= $row['id']; ?>" onclick="return confirm('Delete?')"
                            class="btn btn-sm btn-danger">Delete</a>
                    </td>
                </tr>

                <!-- EDIT MODAL -->
                <div class="modal fade" id="editModal<?= $row['id']; ?>" tabindex="-1">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content bg-dark text-white">

                            <form method="post" enctype="multipart/form-data">

                                <div class="modal-header">
                                    <h5>Edit Product #<?= $row['id']; ?></h5>
                                    <button type="button" class="btn-close bg-white" data-bs-dismiss="modal"></button>
                                </div>

                                <div class="modal-body">

                                    <input type="hidden" name="update_id" value="<?= $row['id']; ?>">
                                    <input type="hidden" name="old_image" value="<?= $row['product_image']; ?>">

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label>Category</label>
                                            <select name="category_id" class="form-control edit-cat-select"
                                                data-id="<?= $row['id']; ?>" required>
                                                <?php 
                                                $categories->data_seek(0);
                                                while ($cat = $categories->fetch_assoc()): ?>
                                                <option value="<?= $cat['id']; ?>"
                                                    <?= ($cat['id'] == $row['category_id']) ? "selected" : "" ?>>
                                                    <?= $cat['name']; ?>
                                                </option>
                                                <?php endwhile; ?>
                                            </select>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label>Brand</label>
                                            <select name="brand_id" class="form-control" required>
                                                <?php 
                                                $brands->data_seek(0);
                                                while ($br = $brands->fetch_assoc()): ?>
                                                <option value="<?= $br['id']; ?>"
                                                    <?= ($br['id'] == $row['brand_id']) ? "selected" : "" ?>>
                                                    <?= $br['name']; ?>
                                                </option>
                                                <?php endwhile; ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-3 edit-field edit-common-<?= $row['id']; ?>">
                                        <label>Product Title</label>
                                        <input type="text" name="title" class="form-control"
                                            value="<?= $row['title']; ?>" required>
                                    </div>


                                    <div class="mb-3 edit-field edit-size-<?= $row['id']; ?>">
                                        <label>Size</label>
                                        <input type="text" name="size" value="<?= $row['size']; ?>"
                                            class="form-control">
                                    </div>

                                    <div class="mb-3 edit-field edit-colour-<?= $row['id']; ?>">
                                        <label>Colours</label>
                                        <input type="text" name="colours" value="<?= $row['colours']; ?>"
                                            class="form-control">
                                    </div>

                                    <div class="mb-3 edit-field edit-common-<?= $row['id']; ?>">
                                        <label>Product Image</label>
                                        <input type="file" name="product_image" class="form-control" accept="image/*">
                                        <small>Current: <?= $row['product_image']; ?></small>
                                    </div>

                                </div>

                                <div class="modal-footer">
                                    <button type="submit" name="update_product" class="btn btn-success">Save
                                        Changes</button>
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">Close</button>
                                </div>

                            </form>

                        </div>
                    </div>
                </div>
                <!-- END EDIT MODAL -->

                <?php endwhile; ?>
            </tbody>

        </table>

    </div>
</div>



<?php include 'adminfoot.php'; ?>