<?php
include 'auth.php';
include 'db.php';
include 'adminhead.php';
include 'sidebar.php';

$success = '';
$error = '';

/* ===============================
   DELETE TESTIMONIAL
================================ */
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM testimonials WHERE id=?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "<script>alert('Testimonial deleted!'); window.location='adminreview.php';</script>";
        exit();
    } else {
        $error = "Delete failed: " . $stmt->error;
    }
}

/* ===============================
   ADD TESTIMONIAL
================================ */
if (isset($_POST['add_testimonial'])) {

    $name = $_POST['name'];
    $message = $_POST['message'];
    $rating = intval($_POST['rating']);

    // Image upload
    $image = "";
    if (!empty($_FILES['image']['name'])) {
        $image = time() . "_" . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], "assets/images/" . $image);
    }

    $stmt = $conn->prepare("INSERT INTO testimonials (name, message, rating, image) VALUES (?,?,?,?)");
    $stmt->bind_param("ssis", $name, $message, $rating, $image);

    if ($stmt->execute()) {
        echo "<script>alert('Testimonial Added Successfully!'); window.location='adminreview.php';</script>";
        exit();
    } else {
        $error = "Failed to add testimonial.";
    }
}

/* ===============================
   UPDATE TESTIMONIAL
================================ */
if (isset($_POST['update_testimonial'])) {

    $id = intval($_POST['update_id']);
    $name = $_POST['name'];
    $message = $_POST['message'];
    $rating = intval($_POST['rating']);

    // Image upload
    $image = $_POST['old_image'];
    if (!empty($_FILES['image']['name'])) {
        $image = time() . "_" . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], "assets/images/" . $image);
    }

    $stmt = $conn->prepare("UPDATE testimonials SET name=?, message=?, rating=?, image=? WHERE id=?");
    $stmt->bind_param("ssisi", $name, $message, $rating, $image, $id);

    if ($stmt->execute()) {
        echo "<script>alert('Testimonial Updated!'); window.location='adminreview.php';</script>";
        exit();
    } else {
        $error = "Update failed.";
    }
}

/* ===============================
   FETCH TESTIMONIALS
================================ */
$result = $conn->query("SELECT * FROM testimonials ORDER BY id DESC");
?>

<div class="container-fluid pt-4 px-4">
    <div class="bg-secondary text-light rounded p-4">

        <h4 class="text-center mb-4">Manage Testimonials</h4>

        <form method="post" enctype="multipart/form-data" class="mb-4 text-start" onsubmit="return validateTestimonial();">

    <h5>Add Testimonial</h5><hr class="border-light">

    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Customer Name</label>
            <input type="text" name="name" id="name" class="form-control" required>
        </div>

        <div class="col-md-6 mb-3">
            <label>Rating (1-5)</label>
            <select name="rating" id="rating" class="form-control" required>
                <option value="">Select Rating</option>
                <option>5</option>
                <option>4</option>
                <option>3</option>
                <option>2</option>
                <option>1</option>
            </select>
        </div>
    </div>

    <div class="mb-3">
        <label>Message</label>
        <textarea name="message" id="message" rows="4" class="form-control" required></textarea>
    </div>

    <div class="mb-3">
        <label>Customer Image (optional)</label>
        <input type="file" name="image" id="image" class="form-control" accept="image/*" required>
    </div>

    <button type="submit" name="add_testimonial" class="btn btn-primary">Add Testimonial</button>
</form>


        <!-- Testimonial Table -->
        <div class="table-responsive mt-4">
            <table class="table text-start align-middle table-bordered table-hover mb-0">
                <thead>
                    <tr class="text-white">
                        <th>#</th>
                        <th>Name</th>
                        <th>Message</th>
                        <th>Rating</th>
                        <th>Image</th>
                        <th>Posted</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $i=1; while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++; ?></td>
                        <td><?= htmlspecialchars($row['name']); ?></td>
                        <td><?= substr($row['message'],0,60); ?>...</td>
                        <td><?= $row['rating']; ?> ⭐</td>
                        <td>
                            <?php if ($row['image']): ?>
                                <img src="assets/images/<?= $row['image']; ?>" style="width:50px;border-radius:50%;">
                            <?php else: ?>
                                No Image
                            <?php endif; ?>
                        </td>
                        <td><?= date("d M Y", strtotime($row['posted_on'])); ?></td>

                        <td>
                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal"
                                data-bs-target="#editModal<?= $row['id']; ?>">Edit</button>

                            <a onclick="return confirm('Delete testimonial?')"
                                href="adminreview.php?delete=<?= $row['id']; ?>"
                                class="btn btn-sm btn-primary">
                                Delete
                            </a>
                        </td>
                    </tr>

                    <!-- EDIT MODAL -->
                    <div class="modal fade" id="editModal<?= $row['id']; ?>" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content bg-dark text-white">

                                <form method="post" enctype="multipart/form-data">

                                    <div class="modal-header">
                                        <h5>Edit Testimonial #<?= $row['id']; ?></h5>
                                        <button type="button" class="btn-close bg-white" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">

                                        <input type="hidden" name="update_id" value="<?= $row['id']; ?>">
                                        <input type="hidden" name="old_image" value="<?= $row['image']; ?>">

                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label>Customer Name</label>
                                                <input type="text" name="name" class="form-control"
                                                       value="<?= htmlspecialchars($row['name']); ?>" required>
                                            </div>

                                            <div class="col-md-6 mb-3">
                                                <label>Rating</label>
                                                <select name="rating" class="form-control">
                                                    <?php for($s=5;$s>=1;$s--): ?>
                                                        <option <?= ($row['rating']==$s)?"selected":""; ?>><?= $s; ?></option>
                                                    <?php endfor; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="mb-3">
                                            <label>Message</label>
                                            <textarea name="message" class="form-control" rows="4"><?= htmlspecialchars($row['message']); ?></textarea>
                                        </div>

                                        <div class="mb-3">
                                            <label>Customer Image</label>
                                            <input type="file" name="image" class="form-control">
                                            <?php if ($row['image']): ?>
                                                <img src="assets/images/<?= $row['image']; ?>" width="80" class="mt-2 rounded">
                                            <?php endif; ?>
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <button type="submit" name="update_testimonial" class="btn btn-success">Save Changes</button>
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- END EDIT MODAL -->

                    <?php endwhile; ?>
                </tbody>

            </table>
        </div>

    </div>
</div>

<?php include 'adminfoot.php'; ?>
