<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendors/autoload.php';
include 'header.php';
include 'db.php';

date_default_timezone_set('Asia/Kolkata');
$adminEmail = "mubigct@gmail.com";

// Check job ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo "<script>alert('Invalid job ID'); window.location='career.php';</script>";
    exit;
}

$job_id = intval($_GET['id']);
$job = $conn->query("SELECT * FROM jobs WHERE id = $job_id")->fetch_assoc();

if (!$job) {
    echo "<script>alert('Job not found'); window.location='career.php';</script>";
    exit;
}

$errors = [];
$success = "";

// ===============================
// FORM SUBMISSION
// ===============================
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $name  = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $resume = $_FILES['resume'];

    // ---------------------------
    // VALIDATION
    // ---------------------------
    if (empty($name)) $errors[] = "Name is required.";

    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL))
        $errors[] = "Valid email is required.";

    if (empty($phone)) {
        $errors[] = "Phone number is required.";
    } elseif (!preg_match('/^[0-9]{10}$/', $phone)) {
        $errors[] = "Please enter a valid 10-digit phone number.";
    }

    if (empty($resume['name'])) 
        $errors[] = "Resume file is required.";

    // If no validation errors
    if (empty($errors)) {

        // Allowed formats
        $allowed = ['pdf', 'doc', 'docx'];
        $ext = strtolower(pathinfo($resume["name"], PATHINFO_EXTENSION));

        // Upload path
        $uploadDir = "uploads/resumes/";
        if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

        $fileName = time() . "_" . basename($resume["name"]);
        $targetFile = $uploadDir . $fileName;

        if (in_array($ext, $allowed)) {

            if (move_uploaded_file($resume["tmp_name"], $targetFile)) {

                // ---------------------------
                // INSERT INTO DATABASE
                // ---------------------------
                $stmt = $conn->prepare("
                    INSERT INTO applications (job_id, name, email, phone, resume, applied_on)
                    VALUES (?, ?, ?, ?, ?, NOW())
                ");

                $stmt->bind_param("issss", $job_id, $name, $email, $phone, $fileName);
                $stmt->execute();

                // ---------------------------
                // SEND EMAIL NOTIFICATION
                // ---------------------------
                $mail = new PHPMailer(true);

                try {
                    $mail->isSMTP();
                    $mail->Host = 'mubashira.astradevelops.in';
                    $mail->SMTPAuth = true;
                    $mail->Username = 'dreams@mubashira.astradevelops.in';
                    $mail->Password = ';@5y%}W}mK37Q@8_';
                    $mail->SMTPSecure = 'ssl';
                    $mail->Port = 465;

                    $mail->setFrom('dreams@mubashira.astradevelops.in', 'Dreams Ceramics Careers');
                    $mail->addAddress($adminEmail);

                    $mail->isHTML(true);
                    $mail->Subject = "New Application - " . $job['title'];

                    $mail->Body = "
                        <h2>New Job Application Received</h2>
                        <p><b>Position:</b> {$job['title']}</p>
                        <p><b>Name:</b> {$name}</p>
                        <p><b>Email:</b> {$email}</p>
                        <p><b>Phone:</b> {$phone}</p>
                        <p>Resume is attached.</p>
                        <p><small>Submitted on " . date("d M Y, h:i A") . "</small></p>
                    ";

                    $mail->addAttachment($targetFile);
                    $mail->send();

                    $success = "Your application has been submitted successfully!";

                } catch (Exception $e) {
                    $errors[] = "Application saved but email could not be sent.";
                }

            } else {
                $errors[] = "Failed to upload resume.";
            }

        } else {
            $errors[] = "Only PDF, DOC, and DOCX files are allowed.";
        }
    }
}
?>

<!-- ***** JOB APPLY HERO BANNER (MATCHING MAIN BANNER STYLE) ***** -->
<section class="section main-banner" id="apply-banner" data-section="section-apply"
         style="position: relative; height: 350px; background: url('assets/images/itembg.jpg') center/cover no-repeat;">
    
    <!-- Dark Overlay -->
    <div class="video-overlay header-text">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">

                    <!-- Caption -->
                    <div class="caption text-center">
                        <h6>You're Applying For</h6>
                        <h2><?= htmlspecialchars($job['title']); ?></h2>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>

<!-- ==========================
         APPLY FORM
============================ -->
<section style="padding: 50px 0;">
    <div class="container">

        <?php if (!empty($errors)): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php foreach ($errors as $e) echo "<li>$e</li>"; ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?= $success; ?></div>
        <?php endif; ?>

        <div class="card shadow p-4">
            <form method="POST" enctype="multipart/form-data">

                <div class="row">

                    <div class="col-md-6 mb-3">
                        <label>Your Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label>Email Address</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label>Phone Number</label>
                        <input type="text" name="phone" class="form-control"
                               maxlength="10" pattern="[0-9]{10}"
                               title="Enter a valid 10-digit phone number" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label>Resume (PDF, DOC, DOCX)</label>
                        <input type="file" name="resume" class="form-control" accept=".pdf,.doc,.docx" required>
                    </div>

                    <div class="col-12 text-center mt-3">
                        <button type="submit" class="btn btn-danger px-5 py-2">
                            Submit Application
                        </button>
                    </div>

                </div>

            </form>
        </div>

    </div>
</section>

<?php include 'footer.php'; ?>
