<?php include 'header.php'; ?>
<?php include 'db.php'; ?>

<!-- ***** CAREER HERO BANNER (MAIN BANNER STYLE) ***** -->
<section class="section main-banner" id="top" data-section="section1" 
         style="position: relative; height: 400px; background: url('assets/images/itembg.jpg') center/cover no-repeat;">
    <div class="video-overlay header-text">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="caption text-center">
                        <h6>Build Your Future With Us</h6>
                        <h2>Careers at Dreams Ceramics</h2>
                        <p>
                            Explore exciting opportunities in tiles, sanitaryware, paints, and granite.  
                            Join a growing team and shape your career with industry leaders.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ================================ -->
<!-- AVAILABLE JOBS SECTION -->
<!-- ================================ -->
<section class="upcoming-meetings" id="jobs">
    <div class="container">
        <div class="row">

            <div class="col-lg-12">
                <div class="section-heading">
                    <h2>Current Openings</h2>
                </div>
            </div>

            <?php
            $jobs = $conn->query("SELECT * FROM jobs ORDER BY id DESC");

            if ($jobs->num_rows > 0):
                while ($job = $jobs->fetch_assoc()):
            ?>

            <div class="col-lg-6 mb-4">
                <div class="meeting-item">
                    <div class="down-content">
                        <h4><?= htmlspecialchars($job['title']); ?></h4>

                        <p>
                            <strong>Department:</strong> <?= htmlspecialchars($job['department']); ?><br>
                            <strong>Location:</strong> <?= htmlspecialchars($job['location']); ?><br>
                            <strong>Type:</strong> <?= htmlspecialchars($job['type']); ?><br>
                            <strong>Posted:</strong> <?= date("d M Y", strtotime($job['posted_on'])); ?>
                        </p>

                        <p><?= nl2br(htmlspecialchars($job['description'])); ?></p>

                        <div class="main-button-red mt-3">
                            <a href="apply.php?id=<?= $job['id']; ?>">Apply Now</a>
                        </div>
                    </div>
                </div>
            </div>

            <?php endwhile; ?>

            <?php else: ?>

            <div class="col-lg-12 text-center">
                <h4>No job openings available at the moment.</h4>
                <p>Please check back later.</p>
            </div>

            <?php endif; ?>

        </div>
    </div>
</section>

<!-- ================================ -->
<!-- CAREER SECTION (Styled Like Meetings) -->
<!-- ================================ -->
<section class="upcoming-meetings" id="apply">
    <div class="container">
        <div class="row">

            <!-- SECTION HEADING -->
            <div class="col-lg-12">
                <div class="section-heading">
                    <h2>Careers at Dreams Ceramics</h2>
                </div>
            </div>

            <!-- LEFT SIDE CATEGORY BOX -->
            <div class="col-lg-4">
                <div class="categories">
                    <h4>Why Join Us?</h4>
                    <ul>
                        <li><a href="#">Work Culture</a></li>
                        <li><a href="#">Career Growth</a></li>
                        <li><a href="#">Employee Benefits</a></li>
                        <li><a href="#">Training & Development</a></li>
                    </ul>

                    <div class="main-button-red">
                        <a href="#jobs">View Current Openings</a>
                    </div>
                </div>
            </div>

            <!-- RIGHT SIDE CAREER ITEMS -->
            <div class="col-lg-8">
                <div class="row">

                    <!-- ITEM 1 -->
                    <div class="col-lg-6">
                        <div class="meeting-item">
                            <div class="thumb">
                                <a><img src="assets/images/career1.jpg" alt=""></a>
                            </div>
                            <div class="down-content">
                                <a><h4>Work Culture</h4></a>
                                <p>We maintain a friendly and collaborative environment that brings out the best in you.</p>
                            </div>
                        </div>
                    </div>

                    <!-- ITEM 2 -->
                    <div class="col-lg-6">
                        <div class="meeting-item">
                            <div class="thumb">
                                <a><img src="assets/images/career2.jpg" alt=""></a>
                            </div>
                            <div class="down-content">
                                <a><h4>Career Growth</h4></a>
                                <p>We offer continuous training and a structured growth path for your career advancement.</p>
                            </div>
                        </div>
                    </div>

                    <!-- ITEM 3 -->
                    <div class="col-lg-6">
                        <div class="meeting-item">
                            <div class="thumb">
                                <a><img src="assets/images/career3.jpg" alt=""></a>
                            </div>
                            <div class="down-content">
                                <a><h4>Employee Benefits</h4></a>
                                <p>Enjoy bonuses, incentives, leave benefits, and special employee discounts.</p>
                            </div>
                        </div>
                    </div>

                    <!-- ITEM 4 -->
                    <div class="col-lg-6">
                        <div class="meeting-item">
                            <div class="thumb">
                                <a><img src="assets/images/career4.jpg" alt=""></a>
                            </div>
                            <div class="down-content">
                                <a><h4>Training & Development</h4></a>
                                <p>Gain hands-on product knowledge and market training to boost your skills.</p>
                            </div>
                        </div>
                    </div>

                </div> <!-- row -->
            </div> <!-- col-lg-8 -->

        </div>
    </div>
</section>
<style>
/* Remove big gap between the two sections */
#jobs.upcoming-meetings,
#apply.upcoming-meetings {
    padding-top: 40px !important;
    padding-bottom: 40px !important;
    margin: 0 !important;
}
</style>


<?php include 'footer.php'; ?>
