<?php
include 'header.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendors/autoload.php';
include 'db.php';

date_default_timezone_set('Asia/Kolkata');

// Admin Email
$adminEmail = "mubigct@gmail.com";

// Form variables
$errors = ['name'=>'','email'=>'','phone'=>'','message'=>''];
$name = $email = $phone = $message = "";

// Handle form submit
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    $name    = trim($_POST['name']);
    $email   = trim($_POST['email']);
    $phone   = trim($_POST['phone']);
    $message = trim($_POST['message']);
    $submitted_at = date("Y-m-d H:i:s");

    // --- VALIDATION ---
    if (empty($name))  $errors['name'] = "Name is required.";
    if (empty($email)) $errors['email'] = "Email is required.";
    elseif (!filter_var($email, FILTER_VALIDATE_EMAIL))
        $errors['email'] = "Invalid email format.";

    if (empty($phone)) $errors['phone'] = "Phone is required.";
    elseif (!preg_match('/^[0-9]{10}$/', $phone))
        $errors['phone'] = "Phone must be 10 digits.";

    if (empty($message)) $errors['message'] = "Message is required.";

    // If NO errors → Save + Send Mail
    if (!array_filter($errors)) {

        // INSERT INTO DATABASE
        $stmt = $conn->prepare("INSERT INTO contact (name,email,phone,message,created_at) VALUES (?,?,?,?,?)");
        $stmt->bind_param("sssss", $name, $email, $phone, $message, $submitted_at);

        if ($stmt->execute()) {

            // SEND EMAIL
            $mail = new PHPMailer(true);

            try {
                $mail->isSMTP();
                $mail->Host       = 'mubashira.astradevelops.in';
                $mail->SMTPAuth   = true;
                $mail->Username   = 'dreams@mubashira.astradevelops.in';
                $mail->Password   = ';@5y%}W}mK37Q@8_'; 
                $mail->SMTPSecure = 'ssl';
                $mail->Port       = 465;

                $mail->setFrom('dreams@mubashira.astradevelops.in', 'Dreams Ceramics Website');
                $mail->addAddress($adminEmail);
                $mail->isHTML(true);

                $mail->Subject = "New Contact Inquiry - Dreams Ceramics";

                // Safe values
                $safeName  = htmlspecialchars($name);
                $safeEmail = htmlspecialchars($email);
                $safePhone = htmlspecialchars($phone);
                $safeMsg   = nl2br(htmlspecialchars($message));

                // Email Body
                $mail->Body = "
                    <div style='font-family:Arial;background:#fff;padding:30px;'>
                        <div style='max-width:600px;margin:auto;background:#000;color:#fff;border-radius:10px;overflow:hidden;'>
                            
                            <div style='background:#c8102e;padding:15px;text-align:center;'>
                                <h2 style='margin:0;color:#fff;'>📨 New Contact Message</h2>
                            </div>

                            <div style='padding:20px;background:#fff;color:#000;'>
                                <h3>Contact Details</h3>
                                <table style='width:100%;'>
                                    <tr><td><strong>Name:</strong></td><td>{$safeName}</td></tr>
                                    <tr><td><strong>Email:</strong></td><td><a href='mailto:$safeEmail'>$safeEmail</a></td></tr>
                                    <tr><td><strong>Phone:</strong></td><td>$safePhone</td></tr>
                                    <tr><td><strong>Message:</strong></td><td>$safeMsg</td></tr>
                                </table>
                                <p style='font-size:12px;color:#666;text-align:right;margin-top:10px;'>Submitted on ".date("d M Y, h:i A")."</p>
                            </div>

                            <div style='background:#c8102e;color:#fff;padding:10px;text-align:center;'>
                                © ".date('Y')." Dreams Ceramics — All Rights Reserved
                            </div>

                        </div>
                    </div>
                ";

                $mail->send();

                echo "<script>
                    alert('✅ Thank you! Your message has been sent successfully.');
                    window.location.href='contact.php';
                </script>";

            } catch (Exception $e) {
                error_log('Mail Error: ' . $mail->ErrorInfo);
            }
        }
    }
}
?>

<!-- ***** HERO BANNER ***** -->
<section class="section main-banner" id="top" 
    style="position:relative;height:400px;background:url('assets/images/bg18.jpg') center/cover no-repeat;">
    <div class="video-overlay header-text">
        <div class="container">
           
        </div>
    </div>
</section>

<!-- ***** CONTACT FORM ***** -->
<section class="contact-us" id="contact">
    <div class="container">
        <div class="row">

            <!-- FORM -->
            <div class="col-lg-9">
                <form id="contact" method="post">
                    <div class="row">
                        <div class="col-lg-12"><h2>Let's Get In Touch</h2></div>

                        <div class="col-lg-4">
                            <input type="text" name="name" placeholder="YOUR NAME...*" 
                                   value="<?= htmlspecialchars($name) ?>" required>
                            <small style="color:red;"><?= $errors['name'] ?></small>
                        </div>

                        <div class="col-lg-4">
                            <input type="text" name="email" placeholder="YOUR EMAIL...*" 
                                   value="<?= htmlspecialchars($email) ?>" required>
                            <small style="color:red;"><?= $errors['email'] ?></small>
                        </div>

                        <div class="col-lg-4">
                            <input type="text" name="phone" placeholder="YOUR PHONE...*" 
                                   value="<?= htmlspecialchars($phone) ?>" required>
                            <small style="color:red;"><?= $errors['phone'] ?></small>
                        </div>

                        <div class="col-lg-12">
                            <textarea name="message" placeholder="YOUR MESSAGE..." required><?= htmlspecialchars($message) ?></textarea>
                            <small style="color:red;"><?= $errors['message'] ?></small>
                        </div>

                        <div class="col-lg-12">
                            <button type="submit" class="button">SEND MESSAGE NOW</button>
                        </div>
                    </div>
                </form>
            </div>

            <!-- RIGHT BOX -->
            <div class="col-lg-3">
                <div class="contact-box">
                    <ul>
                        <li>
                            <h6>Phone Number</h6>
                            <a class="info-text" href="tel:9946580977">9946580977</a><br>
                            <a class="info-text" href="tel:9961007916">9961007916</a>
                        </li>

                        <li>
                            <h6>Email Address</h6>
                            <a class="info-text" href="mailto:dreamceramicsiritty@gmail.com">
                                dreamceramicsiritty@gmail.com
                            </a>
                        </li>

                        <li>
                            <h6>Street Address</h6>
                            <span class="info-text">Iritty, Kerala</span>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- STYLES -->
            <style>
            .contact-box {
                background: #cc0000;
                color: #fff;
                padding: 25px;
                border-radius: 20px;
            }

            .contact-box ul {
                list-style: none;
                margin: 0;
                padding: 0;
            }

            .contact-box li {
                margin-bottom: 25px;
            }

            .contact-box h6 {
                font-weight: 700;
                margin-bottom: 5px;
            }

            .contact-box .info-text {
                color: #fff;
                font-size: 16px;
                display: inline-block;
                word-break: break-word;
            }

            /* ---------- Responsive ---------- */
            @media (max-width: 991px) {
                .contact-box {
                    margin-top: 30px;
                }
            }

            @media (max-width: 575px) {
                .contact-box {
                    padding: 20px;
                    text-align: left;
                }

                .contact-box .info-text {
                    font-size: 15px;
                }
            }
            </style>

        </div>
    </div>
</section>

<?php include 'footer.php'; ?>
