<?php
include 'auth.php';
include 'db.php';
include 'adminhead.php';
include 'sidebar.php';

// Fetch counts
$total_contacts = $conn->query("SELECT COUNT(*) AS total FROM contact")->fetch_assoc()['total'];
$total_products = $conn->query("SELECT COUNT(*) AS total FROM products")->fetch_assoc()['total'];
$total_careers = $conn->query("SELECT COUNT(*) AS total FROM jobs")->fetch_assoc()['total'];
$total_applications = $conn->query("SELECT COUNT(*) AS total FROM applications")->fetch_assoc()['total'];
?>

<div class="container-fluid pt-4 px-4">
    <div class="bg-secondary text-light rounded p-4">

        <h4 class="text-center mb-4">Dashboard Overview</h4>

        <div class="row g-4">

            <!-- CONTACT MESSAGES -->
            <div class="col-sm-6 col-xl-3">
                <div class="bg-dark rounded p-4 text-center h-100 shadow-sm">
                    <i class="fa fa-envelope fa-3x text-primary mb-3"></i>
                    <h3 class="text-white mb-2"><?= $total_contacts ?></h3>
                    <p class="text-light mb-3">Contact Messages</p>
                    <a href="viewcontact.php" class="btn btn-primary btn-sm w-100">View</a>
                </div>
            </div>

            <!-- PRODUCTS -->
            <div class="col-sm-6 col-xl-3">
                <div class="bg-dark rounded p-4 text-center h-100 shadow-sm">
                    <i class="fa fa-box fa-3x text-info mb-3"></i>
                    <h3 class="text-white mb-2"><?= $total_products ?></h3>
                    <p class="text-light mb-3">Products</p>
                    <a href="adminproducts.php" class="btn btn-info btn-sm w-100">Manage</a>
                </div>
            </div>

            <!-- CAREER POSTS -->
            <div class="col-sm-6 col-xl-3">
                <div class="bg-dark rounded p-4 text-center h-100 shadow-sm">
                    <i class="fa fa-briefcase fa-3x text-danger mb-3"></i>
                    <h3 class="text-white mb-2"><?= $total_careers ?></h3>
                    <p class="text-light mb-3">Career Posts</p>
                    <a href="admincareer.php" class="btn btn-danger btn-sm w-100">Manage</a>
                </div>
            </div>

            <!-- APPLICATIONS -->
            <div class="col-sm-6 col-xl-3">
                <div class="bg-dark rounded p-4 text-center h-100 shadow-sm">
                    <i class="fa fa-file-alt fa-3x text-warning mb-3"></i>
                    <h3 class="text-white mb-2"><?= $total_applications ?></h3>
                    <p class="text-light mb-3">Applications</p>
                    <a href="viewapplications.php" class="btn btn-warning btn-sm w-100">View</a>
                </div>
            </div>

        </div>

        <hr class="border-light my-4">

        <!-- Footer welcome box -->
        <div class="bg-dark rounded p-4">
            <h5 class="text-white mb-3">Welcome to Dreams Ceramics Admin Dashboard</h5>
            <p class="text-light">
                Manage your products, career posts, applications, and messages using the menu on the left.
            </p>
        </div>

    </div>
</div>


<?php include 'adminfoot.php'; ?>
