<?php include 'header.php';?>
<!-- ***** Main Banner Area Start ***** -->
<section class="section main-banner" id="top" data-section="section1">
    <video autoplay muted loop id="bg-video">
        <source src="assets/images/video1.mp4" type="video/mp4" />
    </video>

    <div class="video-overlay header-text">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="caption">
                        <h6>Welcome to Dreams Ceramics</h6>
                        <h2>Tiles • Sanitary • Granite • Paints</h2>
                        <p>
                            At <strong>Dreams Ceramics</strong>, we offer premium <strong>tiles, sanitaryware, paints,
                                and granites</strong>
                            from trusted brands like Somany, AGL, Johnson, and Berger — helping you create elegant,
                            lasting spaces.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>
<!-- ***** Main Banner Area End ***** -->

<section class="services" style="padding-bottom:80px;">

    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="owl-service-item owl-carousel">

                    <div class="item">
                        <div class="icon">
                            <img src="assets/images/service-icon-01.png" alt="">
                        </div>
                        <div class="down-content">
                            <h4>Premium Tiles</h4>
                            <p>Explore elegant and durable tiles that transform your interiors with style and
                                long-lasting beauty.</p>
                        </div>
                    </div>

                    <div class="item">
                        <div class="icon">
                            <img src="assets/images/service-icon-02.png" alt="">
                        </div>
                        <div class="down-content">
                            <h4>Sanitaryware</h4>
                            <p>Modern, water-efficient sanitaryware that brings both comfort and sophistication to every
                                space.</p>
                        </div>
                    </div>

                    <div class="item">
                        <div class="icon">
                            <img src="assets/images/service-icon-03.png" alt="">
                        </div>
                        <div class="down-content">
                            <h4>Quality Paints</h4>
                            <p>Choose from a wide range of premium paints that offer smooth finishes and vibrant color
                                durability.</p>
                        </div>
                    </div>

                    <div class="item">
                        <div class="icon">
                            <img src="assets/images/service-icon-02.png" alt="">
                        </div>
                        <div class="down-content">
                            <h4>Granite & Stones</h4>
                            <p>Add strength and timeless appeal with natural granites ideal for countertops, floors, and
                                facades.</p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>



<?php
include 'db.php';
$partners = $conn->query("SELECT * FROM partners ORDER BY id DESC");
?>

<section id="partners" style="padding:150px 0; margin-top:300px; background:#1A0D09;">
    <div class="container">

        <!-- TITLE -->
        <div class="row">
            <div class="col-lg-12 text-center mb-4">
                <h6 style="color:#d2a100; font-weight:600; letter-spacing:2px;">OUR PARTNERS</h6>
                <h2 style="font-weight:700;">Explore Our <span style="color:#d2a100;">PARTNERS</span></h2>
            </div>
        </div>

        <!-- LOGO GRID -->
        <div class="row justify-content-center">

            <?php while ($row = $partners->fetch_assoc()): ?>
            <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-4">

                <div style="
                    background:rgb(210 161 0 / 72%);
                    border-radius:10px;
                    border:3px solid #000;
                    height:120px;
                    display:flex;
                    align-items:center;
                    justify-content:center;
                    padding:10px;
                    transition:0.3s;
                " onmouseover="this.style.transform='scale(1.05)';" onmouseout="this.style.transform='scale(1)';">

                    <img src="<?= $row['brand_image']; ?>" alt="<?= htmlspecialchars($row['title']); ?>"
                        style="max-height:80px; width:auto; object-fit:contain;">
                </div>

            </div>
            <?php endwhile; ?>

        </div>

    </div>
</section>


<?php
include 'db.php';

// Fetch jobs
$jobs = $conn->query("SELECT * FROM jobs ORDER BY id DESC limit 2");
?>

<section class="apply-now" id="apply">
    <div class="container">
        <div class="row">

            <!-- LEFT SIDE — JOB LISTINGS -->
            <div class="col-lg-6 align-self-center">
                <div class="row">

                    <?php while ($job = $jobs->fetch_assoc()): ?>
                    <div class="col-lg-12">
                        <div class="item">
                            <h3><?= htmlspecialchars($job['title']); ?></h3>

                            <p>
                                <strong>Department:</strong> <?= htmlspecialchars($job['department']); ?><br>
                                <strong>Location:</strong> <?= htmlspecialchars($job['location']); ?><br>
                                <strong>Type:</strong> <?= htmlspecialchars($job['type']); ?>
                            </p>

                            <div class="main-button-red">
                                <a href="apply.php?id=<?= $job['id']; ?>">Apply Now</a>
                            </div>

                        </div>
                    </div>
                    <?php endwhile; ?>

                </div>
            </div>

            <!-- RIGHT SIDE — ACCORDION: JOB DESCRIPTIONS -->
            <div class="col-lg-6">
                <div class="accordions is-first-expanded">

                    <?php
                    // Fetch again for accordion
                    $jobs2 = $conn->query("SELECT * FROM jobs ORDER BY id DESC");
                    $accIndex = 1;
                    ?>

                    <?php while ($job = $jobs2->fetch_assoc()): ?>
                    <article class="accordion <?= ($accIndex == 1 ? 'is-first-expanded' : ''); ?>">
                        <div class="accordion-head">
                            <span><?= htmlspecialchars($job['title']); ?> — Details</span>
                            <span class="icon"><i class="icon fa fa-chevron-right"></i></span>
                        </div>

                        <div class="accordion-body">
                            <div class="content">
                                <p>
                                    <?= nl2br(htmlspecialchars($job['description'])); ?>
                                </p>

                                <p>
                                    <strong>Department:</strong> <?= htmlspecialchars($job['department']); ?><br>
                                    <strong>Location:</strong> <?= htmlspecialchars($job['location']); ?><br>
                                    <strong>Type:</strong> <?= htmlspecialchars($job['type']); ?><br>
                                    <strong>Posted:</strong> <?= date("d M Y", strtotime($job['posted_on'])); ?>
                                </p>

                                <div class="main-button-yellow mt-3">
                                    <a href="apply.php?id=<?= $job['id']; ?>">Apply for this Job</a>
                                </div>

                            </div>
                        </div>
                    </article>
                    <?php 
                        $accIndex++; 
                        endwhile; 
                    ?>

                </div>
            </div>

        </div>
    </div>
</section>



<?php
include 'db.php';

// Fetch Products with Category + Brand
$products = $conn->query("
    SELECT products.*, categories.name AS category_name, brands.name AS brand_name
    FROM products
    LEFT JOIN categories ON products.category_id = categories.id
    LEFT JOIN brands ON products.brand_id = brands.id
    ORDER BY products.id DESC
");
?>

<style>
/* PRODUCT CARD STYLE (Unified with Product Page) */
.product-card {
    background: #fff;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.12);
    transition: all 0.3s ease;
    height: 380px;
    display: flex;
    flex-direction: column;
}

.product-card:hover {
    transform: scale(1.03);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.18);
}

/* IMAGE */
.product-img {
    height: 220px;
    width: 100%;
    object-fit: cover;
    border-bottom: 3px solid #cc0000;
}

/* CONTENT */
.product-info {
    padding: 15px;
}

.product-title {
    font-weight: 700;
    font-size: 18px;
    margin-bottom: 10px;
    color: #cc0000;
}

/* BADGES */
.badge-category {
    background: #222;
    color: #fff;
    padding: 5px 10px;
    border-radius: 6px;
    font-size: 12px;
    margin-right: 5px;
}

.badge-brand {
    background: #cc0000;
    color: #fff;
    padding: 5px 10px;
    border-radius: 6px;
    font-size: 12px;
}

/* RESPONSIVE FIX if Owl fails */
@media(max-width: 768px) {
    .owl-carousel .item {
        margin-bottom: 20px;
    }
}
</style>

<section class="our-courses" id="courses">
    <div class="container">
        <div class="row">

            <div class="col-lg-12">
                <div class="section-heading">
                    <h2>Our Featured Products</h2>
                    <h6 style="color:#666;">Tiles • Sanitary • Granite • Paints</h6>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="owl-courses-item owl-carousel">

                    <?php while ($p = $products->fetch_assoc()): ?>
                    <div class="item">

                        <div class="product-card">

                            <!-- PRODUCT IMAGE -->
                            <img src="assets/images/<?= $p['product_image']; ?>" alt="<?= $p['title']; ?>"
                                class="product-img">

                            <!-- CONTENT -->
                            <div class="product-info">

                                <h4 class="product-title"><?= $p['title']; ?></h4>

                                <span class="badge-category"><?= $p['category_name']; ?></span>
                                <span class="badge-brand"><?= $p['brand_name']; ?></span>

                                <?php if (!empty($p['size'])): ?>
                                <div class="product-size mt-2">
                                    <strong>Size:</strong> <?= $p['size']; ?>
                                </div>
                                <?php endif; ?>


                            </div>

                        </div>

                    </div>
                    <?php endwhile; ?>

                </div>
            </div>

        </div>
    </div>
</section>



<!-- ========== DREAMS CERAMICS FACTS SECTION ========== -->
<section class="our-facts" style="padding: 80px 0; background:#1A0D09;">
    <div class="container">
        <div class="row">

            <!-- LEFT SIDE - FACTS -->
            <div class="col-lg-6">
                <div class="row">
                    <div class="col-12">
                        <h2 style="color:#d10000; margin-bottom:25px; font-weight:700;">
                            A Few Facts About Dreams Ceramics
                        </h2>
                    </div>

                    <!-- FACT – Tiles -->
                    <div class="col-lg-6 col-sm-6 mb-4">
                        <div class="count-area-content"
                            style="background:white;padding:20px;border-radius:10px;box-shadow:0 3px 10px rgba(0,0,0,0.1);">
                            <div class="count-digit" data-count="5000"
                                style="font-size:32px;font-weight:700;color:#000;">5000</div>
                            <div class="count-title" style="color:#333;">Tiles Collection</div>
                        </div>
                    </div>

                    <!-- FACT – Sanitary -->
                    <div class="col-lg-6 col-sm-6 mb-4">
                        <div class="count-area-content"
                            style="background:white;padding:20px;border-radius:10px;box-shadow:0 3px 10px rgba(0,0,0,0.1);">
                            <div class="count-digit" data-count="1200"
                                style="font-size:32px;font-weight:700;color:#000;">1200</div>
                            <div class="count-title" style="color:#333;">Sanitary Products</div>
                        </div>
                    </div>

                    <!-- FACT – Granite -->
                    <div class="col-lg-6 col-sm-6 mb-4">
                        <div class="count-area-content"
                            style="background:white;padding:20px;border-radius:10px;box-shadow:0 3px 10px rgba(0,0,0,0.1);">
                            <div class="count-digit" data-count="300"
                                style="font-size:32px;font-weight:700;color:#000;">300</div>
                            <div class="count-title" style="color:#333;">Granite Designs</div>
                        </div>
                    </div>

                    <!-- FACT – Paints -->
                    <div class="col-lg-6 col-sm-6 mb-4">
                        <div class="count-area-content"
                            style="background:white;padding:20px;border-radius:10px;box-shadow:0 3px 10px rgba(0,0,0,0.1);">
                            <div class="count-digit" data-count="15" style="font-size:32px;font-weight:700;color:#000;">
                                15</div>
                            <div class="count-title" style="color:#333;">Premium Paint Brands</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- RIGHT SIDE – BRANDS LIST -->
            <div class="col-lg-6 align-self-center">
                <div style="background:white;padding:30px;border-radius:10px;box-shadow:0 3px 10px rgba(0,0,0,0.1);">
                    <h3 style="color:#000;font-weight:700;margin-bottom:20px;">Brands We Offer</h3>

                    <ul style="columns:2; list-style:none; padding:0; margin:0;">
                        <li style="margin-bottom:10px;">✔ Somany</li>
                        <li style="margin-bottom:10px;">✔ AGL</li>
                        <li style="margin-bottom:10px;">✔ LV Granito</li>
                        <li style="margin-bottom:10px;">✔ Varmora</li>
                        <li style="margin-bottom:10px;">✔ Rollza</li>
                        <li style="margin-bottom:10px;">✔ Johnson</li>
                        <li style="margin-bottom:10px;">✔ Kerovit</li>
                        <li style="margin-bottom:10px;">✔ Berger</li>
                        <li style="margin-bottom:10px;">✔ MRF</li>
                        <li style="margin-bottom:10px;">✔ Indigo</li>
                        <li style="margin-bottom:10px;">✔ Turbolux</li>
                        <li style="margin-bottom:10px;">✔ Roff</li>
                        <li style="margin-bottom:10px;">✔ MYK</li>
                    </ul>
                </div>
            </div>

        </div>
    </div>
</section>
<!-- ========== END FACTS SECTION ========== -->



<!-- ========== CUSTOMER REVIEWS SECTION ========== -->
<section class="testimonials" id="reviews" style="padding: 80px 0; background: #f7f7f7;">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 text-center">
                <div class="section-heading" style="color:#000;">
                    <h2 style="color:#000;">What Our Customers Say</h2>
                    <p style="color:#555;">Real feedback from people who trust Dreams Ceramics</p>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="owl-courses-item owl-carousel">

                    <?php
                    include 'db.php';
                    $result = $conn->query("SELECT * FROM testimonials ORDER BY id DESC LIMIT 10");

                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            $image = !empty($row['image']) ? "assets/images/" . $row['image'] : "assets/images/default-user.png";
                            ?>

                    <div class="item" style="padding:20px;">
                        <div class="card"
                            style="border-radius: 10px; padding: 20px; background:white; box-shadow:0 3px 10px rgba(0,0,0,0.1);">

                            <div class="text-center">
                                <img src="<?php echo $image; ?>"
                                    style="width:80px;height:80px;border-radius:50%;object-fit:cover;margin-bottom:15px;">
                                <h4><?php echo htmlspecialchars($row['name']); ?></h4>
                            </div>

                            <div class="text-center" style="color:#f1c40f;">
                                <?php for ($i = 1; $i <= 5; $i++) {
                                            echo ($i <= $row['rating']) ? "<i class='fa fa-star'></i>" : "<i class='fa fa-star-o'></i>";
                                        } ?>
                            </div>

                            <p style="margin-top:15px; font-size:15px; line-height:1.5;">
                                "<?php echo htmlspecialchars($row['message']); ?>"
                            </p>
                        </div>
                    </div>

                    <?php
                        }
                    } else {
                        echo "<p class='text-center'>No reviews yet. Be the first to share your experience!</p>";
                    }
                    ?>

                </div>
            </div>
        </div>
    </div>
</section>
<!-- ========== END CUSTOMER REVIEWS ========== -->

<!-- Minimal Fix for Owl Carousel nav (no styling added) -->
<style>
#reviews .owl-nav {
    position: absolute;
    top: 50%;
    width: 100%;
    transform: translateY(-50%);
    display: flex;
    justify-content: space-between;
}
</style>



<section class="contact-us" id="contact">
    <div class="container">
        <div class="row">
            <div class="col-lg-9 align-self-center">
                <div class="row">
                    <div class="col-lg-12">
                        <form id="contact" action="" method="post">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h2>Let's get in touch</h2>
                                </div>
                                <div class="col-lg-4">
                                    <fieldset>
                                        <input name="name" type="text" id="name" placeholder="YOURNAME...*" required="">
                                    </fieldset>
                                </div>
                                <div class="col-lg-4">
                                    <fieldset>
                                        <input name="email" type="text" id="email" pattern="[^ @]*@[^ @]*"
                                            placeholder="YOUR EMAIL..." required="">
                                    </fieldset>
                                </div>
                                <div class="col-lg-4">
                                    <fieldset>
                                        <input name="subject" type="text" id="subject" placeholder="SUBJECT...*"
                                            required="">
                                    </fieldset>
                                </div>
                                <div class="col-lg-12">
                                    <fieldset>
                                        <textarea name="message" type="text" class="form-control" id="message"
                                            placeholder="YOUR MESSAGE..." required=""></textarea>
                                    </fieldset>
                                </div>
                                <div class="col-lg-12">
                                    <fieldset>
                                        <button type="submit" id="form-submit" class="button">SEND MESSAGE NOW</button>
                                    </fieldset>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="right-info contact-box">
                    <ul>
                        <li>
                            <h6>Phone Number</h6>
                            <a href="tel:9946580977" class="info-text">9946580977</a><br>
                            <a href="tel:9961007916" class="info-text">9961007916</a>
                        </li>

                        <li>
                            <h6>Email Address</h6>
                            <a href="mailto:dreamceramicsiritty@gmail.com" class="info-text">
                                dreamceramicsiritty@gmail.com
                            </a>
                        </li>

                        <li>
                            <h6>Street Address</h6>
                            <span class="info-text">Iritty, Kerala</span>
                        </li>

                    </ul>
                </div>
            </div>
            <style>
            .contact-box {
                background: #cc0000;
                color: #fff;
                padding: 25px;
                border-radius: 20px;
            }

            .contact-box ul {
                list-style: none;
                margin: 0;
                padding: 0;
            }

            .contact-box li {
                margin-bottom: 25px;
            }

            .contact-box h6 {
                font-weight: 700;
                margin-bottom: 5px;
            }

            .contact-box .info-text {
                color: #fff;
                font-size: 16px;
                display: inline-block;
                word-break: break-word;
            }

            /* ---------- Responsive ---------- */
            @media (max-width: 991px) {
                .contact-box {
                    margin-top: 30px;
                }
            }

            @media (max-width: 575px) {
                .contact-box {
                    padding: 20px;
                    text-align: left;
                }

                .contact-box .info-text {
                    font-size: 15px;
                }
            }
            </style>
        </div>
    </div>
</section>
<?php include 'footer.php';?>