<?php
include 'db.php';
include 'header.php';

// Fetch Categories
$categories = $conn->query("SELECT * FROM categories ORDER BY name ASC");

// Fetch Brands
$brands = $conn->query("SELECT * FROM brands ORDER BY name ASC");

// Fetch Products (full data)
$products = $conn->query(
    "SELECT products.*, categories.name AS category_name, brands.name AS brand_name 
     FROM products
     LEFT JOIN categories ON products.category_id = categories.id
     LEFT JOIN brands ON products.brand_id = brands.id
     ORDER BY products.id DESC"
);

// Featured Product
$featuredProduct = $conn->query(
    "SELECT products.*, categories.name AS category_name, brands.name AS brand_name 
     FROM products
     LEFT JOIN categories ON products.category_id = categories.id
     LEFT JOIN brands ON products.brand_id = brands.id
     ORDER BY products.id DESC LIMIT 1"
)->fetch_assoc();

// Fetch TILE SIZES dynamically
$tileSizes = $conn->query("
    SELECT DISTINCT size 
    FROM products 
    LEFT JOIN categories ON categories.id = products.category_id
    WHERE categories.name = 'Tiles' AND size IS NOT NULL AND size != ''
    ORDER BY size ASC
");
?>

<style>
/* ===== SIDEBAR ===== */
.sidebar {
    background: #ffffff;
    padding: 20px;
    border-radius: 10px;
    width: 100%;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
    position: sticky;
    top: 90px;
    /* Keeps sidebar fixed on scroll */
    z-index: 10;
}

/* Category Title */
.sidebar h4 {
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 15px;
    color: #cc0000;
}

/* Category Items */
.sidebar ul {
    list-style: none;
    padding-left: 0;
}

.sidebar ul li {
    padding: 10px 12px;
    margin-bottom: 8px;
    font-weight: 600;
    cursor: pointer;
    border-radius: 8px;
    transition: 0.3s;
    color: #333;
}

/* Unique colors for each category */
.category-tiles {
    background: #e0f7fa;
}

.category-tiles:hover {
    background: #b2ebf2;
    color: #006064;
}

.category-sanitary {
    background: #fff3cd;
}

.category-sanitary:hover {
    background: #ffe8a1;
    color: #856404;
}

.category-granite {
    background: #e2e3e5;
}

.category-granite:hover {
    background: #d6d8db;
    color: #383d41;
}

.category-paints {
    background: #e8f5e9;
}

.category-paints:hover {
    background: #c8e6c9;
    color: #2e7d32;
}

/* Sub list */
.sub-list {
    padding-left: 15px;
    margin-top: 8px;
}

.sub-list li {
    font-size: 14px;
    padding: 6px 8px;
    margin-bottom: 5px;
    background: #f8f9fa;
    border-radius: 6px;
}

.sub-list li:hover {
    background: #ececec;
    color: #cc0000;
}

/* PRODUCT CARD */
.product-card {
    background: #fff;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.12);
    transition: 0.3s;
}

.product-card:hover {
    transform: scale(1.02);
}

.product-img {
    height: 240px;
    width: 100%;
    object-fit: cover;
}
</style>


<!-- HERO BANNER -->
<section class="section main-banner" id="top" data-section="section1" style="position: relative; height: 500px;
                background: url('assets/images/<?= $featuredProduct['product_image']; ?>') center/cover no-repeat;">
    <div class="video-overlay header-text">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="caption text-center">
                        <?php if($featuredProduct): ?>
                        <h6><?= $featuredProduct['category_name']; ?> by <?= $featuredProduct['brand_name']; ?></h6>
                        <h2><?= $featuredProduct['title']; ?></h2>
                        <?php else: ?>
                        <h6>Explore Our Products</h6>
                        <h2>Tiles • Sanitary • Granite • Paints</h2>
                        <p>Discover premium products from trusted brands like Somany, AGL, Johnson, and Berger.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<div class="container my-5">
    <div class="row">

        <!-- ========== LEFT SIDEBAR ========== -->
        <div class="col-lg-3 mb-4">
            <div class="sidebar">

                <h4>Categories</h4>
                <ul>

                    <!-- TILES -->
                    <li class="category-tiles" onclick="toggleTileSizes(); filterByCategory('Tiles')">
                        Tiles
                    </li>

                    <!-- TILE SIZES -->
                    <ul class="sub-list" id="tileSizeList" style="display: none;">
                        <?php while ($ts = $tileSizes->fetch_assoc()): ?>
                        <li onclick="filterBySize('<?= $ts['size']; ?>'); event.stopPropagation();">
                            <?= $ts['size']; ?>
                        </li>
                        <?php endwhile; ?>
                    </ul>

                    <!-- SANITARY -->
                    <li class="category-sanitary" onclick="hideTileSizes(); filterByCategory('Sanitary')">
                        Sanitary Ware
                    </li>

                    <!-- GRANITE -->
                    <li class="category-granite" onclick="hideTileSizes(); filterByCategory('Granite')">
                        Granite
                    </li>

                    <!-- PAINTS -->
                    <li class="category-paints" onclick="hideTileSizes(); filterByCategory('Paints')">
                        Paints
                    </li>

                </ul>


            </div>
        </div>


        <!-- ========== PRODUCT GRID ========== -->
        <div class="col-lg-9">
            <div class="row" id="productGrid">

                <?php while ($p = $products->fetch_assoc()): ?>
                <div class="col-lg-4 col-md-6 mb-4 product-item" data-category="<?= $p['category_name']; ?>"
                    data-size="<?= $p['size']; ?>">

                    <div class="product-card">
                        <img class="product-img" src="assets/images/<?= $p['product_image']; ?>">

                        <div class="p-3">
                            <h5><?= $p['title']; ?></h5>
                            <p class="mb-1">
                                <strong>Brand:</strong> <?= $p['brand_name']; ?>
                            </p>
                            <p class="mb-1">
                                <strong>Category:</strong> <?= $p['category_name']; ?>
                            </p>
                            <?php if ($p['size']): ?>
                            <p><strong>Size:</strong> <?= $p['size']; ?></p>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
                <?php endwhile; ?>

            </div>
        </div>

    </div>
</div>

<script>
/* ===========================
   SHOW / HIDE TILE SIZES
=========================== */
function toggleTileSizes() {
    const list = document.getElementById('tileSizeList');
    list.style.display = (list.style.display === 'none') ? 'block' : 'none';
}

function hideTileSizes() {
    document.getElementById('tileSizeList').style.display = 'none';
}

/* ===========================
   CATEGORY FILTER
=========================== */
function filterByCategory(category) {
    document.querySelectorAll('.product-item').forEach(item => {
        item.style.display = (item.dataset.category === category) ? 'block' : 'none';
    });
}

/* ===========================
   SIZE FILTER
=========================== */
function filterBySize(size) {
    document.querySelectorAll('.product-item').forEach(item => {
        item.style.display = (item.dataset.size === size) ? 'block' : 'none';
    });
}
</script>


<?php include 'footer.php'; ?>


