<?php
session_start();
include 'db.php';

$message = "";

// Check if email session exists
if (!isset($_SESSION['reset_email'])) {
    header("Location: forgotpassword.php");
    exit();
}

$email = $_SESSION['reset_email'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $newPassword = password_hash($_POST['password'], PASSWORD_BCRYPT);

    $stmt = $conn->prepare("UPDATE admin SET password = ? WHERE email = ?");
    $stmt->bind_param("ss", $newPassword, $email);
    $stmt->execute();

    unset($_SESSION['reset_email']);
    $message = "<div class='alert alert-success text-center'>
                    Password has been reset successfully! 
                    <a href='login.php' class='text-decoration-none'>Login here</a>.
                </div>";
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Reset Password - Dreams Ceramics</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <!-- Favicons -->
    <link href="assets/images/dream logo.png" rel="icon">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600&family=Roboto:wght@500;700&display=swap"
        rel="stylesheet">

    <!-- Icon Fonts -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Template Styles -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

    <style>
        body {
            background: #f4f6f8;
        }

        .login-box {
            max-width: 420px;
            margin: auto;
            margin-top: 5%;
            background: #fff;
            padding: 35px;
            border-radius: 12px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        }

        .login-logo img {
            width: 120px;
        }

        .password-toggle {
            position: absolute;
            right: 15px;
            top: 38px;
            cursor: pointer;
            color: #666;
        }
    </style>
</head>

<body>

    <div class="login-box">
        <div class="text-center login-logo mb-3">
            <img src="assets/images/dream logo.png" alt="Dreams Ceramics">
        </div>

        <h3 class="text-center mb-3 text-primary">Reset Password</h3>

        <?= $message ?>

        <?php if (!$message): ?>
            <form method="POST">

                <div class="mb-3 position-relative">
                    <label>New Password</label>
                    <input type="password" id="password" name="password" required class="form-control"
                        placeholder="Enter new password">
                    <i class="bi bi-eye-slash password-toggle" id="togglePassword"></i>
                </div>

                <button class="btn btn-primary w-100">Update Password</button>

                <div class="text-center mt-3">
                    <a href="login.php">Back to Login</a>
                </div>

            </form>
        <?php endif; ?>
    </div>

    <!-- Password Eye Toggle -->
    <script>
        const togglePassword = document.getElementById("togglePassword");
        const passwordInput = document.getElementById("password");

        togglePassword.addEventListener("click", function () {
            const type = passwordInput.type === "password" ? "text" : "password";
            passwordInput.type = type;

            this.classList.toggle("bi-eye");
            this.classList.toggle("bi-eye-slash");
        });
    </script>

    <!-- JS LIBRARIES (same as login page) -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="lib/tempusdominus/js/moment.min.js"></script>
    <script src="lib/tempusdominus/js/moment-timezone.min.js"></script>
    <script src="lib/tempusdominus/js/tempusdominus-bootstrap-4.min.js"></script>

    <script src="js/main.js"></script>

</body>
</html>
