<?php
include 'auth.php';
include 'adminhead.php';
include 'sidebar.php';
include 'db.php';

// DELETE APPLICATION
if (isset($_GET['delete'])) {
    $delete_id = intval($_GET['delete']);

    // Get resume filename to delete from server
    $fileQ = $conn->query("SELECT resume FROM applications WHERE id = $delete_id");
    $file = $fileQ->fetch_assoc();

    if ($file && !empty($file['resume'])) {
        $filePath = "uploads/resumes/" . $file['resume'];
        if (file_exists($filePath)) {
            unlink($filePath);
        }
    }

    // Delete DB entry
    $stmt = $conn->prepare("DELETE FROM applications WHERE id = ?");
    $stmt->bind_param("i", $delete_id);

    if ($stmt->execute()) {
        echo "<script>alert('Application deleted successfully!'); window.location='viewapplications.php';</script>";
        exit();
    }
}

// FETCH ALL APPLICATIONS
$result = $conn->query("
    SELECT applications.*, jobs.title AS job_title 
    FROM applications 
    LEFT JOIN jobs ON jobs.id = applications.job_id
    ORDER BY applications.id DESC
");
?>

<!-- Applications View Start -->
<div class="container-fluid pt-4 px-4">
    <div class="bg-secondary text-center rounded p-4">

        <div class="d-flex align-items-center justify-content-between mb-4">
            <h6 class="mb-0">Job Applications</h6>
        </div>

        <div class="table-responsive">
            <table class="table text-start align-middle table-bordered table-hover mb-0">
                <thead>
                    <tr class="text-white">
                        <th>#</th>
                        <th>Date</th>
                        <th>Job Title</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Resume</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php 
                    if ($result->num_rows > 0) { 
                        $i = 1;
                        while ($row = $result->fetch_assoc()) { ?>
                        
                        <tr>
                            <td><?= $i++; ?></td>
                            
                            <td><?= date("d M Y, h:i A", strtotime($row['applied_on'])); ?></td>

                            <td><?= htmlspecialchars($row['job_title']); ?></td>

                            <td><?= htmlspecialchars($row['name']); ?></td>

                            <td><?= htmlspecialchars($row['email']); ?></td>

                            <td><?= htmlspecialchars($row['phone']); ?></td>

                            <td>
                                <?php if (!empty($row['resume'])) { ?>
                                    <a href="uploads/resumes/<?= htmlspecialchars($row['resume']); ?>" 
                                       download 
                                       class="btn btn-sm btn-info">
                                       Download
                                    </a>
                                <?php } else { ?>
                                    <span class="text-white">No File</span>
                                <?php } ?>
                            </td>

                            <td>
                                <a onclick="return confirm('Are you sure you want to delete this application?')" 
                                   class="btn btn-sm btn-primary"
                                   href="viewapplications.php?delete=<?= $row['id']; ?>">
                                    Delete
                                </a>
                            </td>
                        </tr>

                    <?php } 
                    } else { ?>
                        <tr>
                            <td colspan="8" class="text-center text-white">
                                No applications found.
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>

            </table>
        </div>

    </div>
</div>
<!-- Applications View End -->

<?php include 'adminfoot.php'; ?>
