<?php
include 'auth.php';
include 'adminhead.php';
include 'sidebar.php';
include 'db.php';

// DELETE OPERATION
if (isset($_GET['delete'])) {
    $delete_id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM contact WHERE id = ?");
    $stmt->bind_param("i", $delete_id);

    if ($stmt->execute()) {
        echo "<script>alert('Contact entry deleted successfully!'); window.location='viewcontact.php';</script>";
        exit();
    }
}

// FETCH ALL CONTACT ENQUIRIES
$result = $conn->query("SELECT * FROM contact ORDER BY id DESC");
?>

<!-- Contact View Start -->
<div class="container-fluid pt-4 px-4">
    <div class="bg-secondary text-center rounded p-4">
        <div class="d-flex align-items-center justify-content-between mb-4">
            <h6 class="mb-0">Contact Enquiries</h6>
        </div>

        <div class="table-responsive">
            <table class="table text-start align-middle table-bordered table-hover mb-0">
                <thead>
                    <tr class="text-white">
                        <th scope="col">ID</th>
                        <th scope="col">Date</th>
                        <th scope="col">Name</th>
                        <th scope="col">Email</th>
                        <th scope="col">Phone</th>
                        <th scope="col">Message</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>

                <tbody>
                    <?php 
                    if ($result->num_rows > 0) {
                        $i = 1;
                        while ($row = $result->fetch_assoc()) { ?>
                            <tr>
                                <td><?= $i++; ?></td>
                                <td><?= date("d M Y, h:i A", strtotime($row['created_at'])); ?></td>
                                <td><?= htmlspecialchars($row['name']); ?></td>
                                <td><?= htmlspecialchars($row['email']); ?></td>
                                <td><?= htmlspecialchars($row['phone']); ?></td>
                                <td><?= nl2br(htmlspecialchars($row['message'])); ?></td>

                                <td>
                                    <a onclick="return confirm('Are you sure you want to delete this enquiry?')"
                                       class="btn btn-sm btn-primary"
                                       href="viewcontact.php?delete=<?= $row['id']; ?>">
                                       Delete
                                    </a>
                                </td>
                            </tr>
                        <?php }
                    } else { ?>
                        <tr>
                            <td colspan="7" class="text-center text-white">No contact enquiries found.</td>
                        </tr>
                    <?php } ?>
                </tbody>

            </table>
        </div>
    </div>
</div>
<!-- Contact View End -->

<?php include 'adminfoot.php'; ?>


