<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description"
    content="Learn about MK Trading Company - Our story, mission, vision, and why we're the trusted choice for hardware and building solutions." />
  <link rel="icon" type="image/png" sizes="16x16" href="asset/images/mk logo1.png">
    <title>About Us - MK Trading Company</title>
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap"
    rel="stylesheet" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
  <style>
    /* Custom AOS animation to match requirements: opacity 0.2 initially */
    [data-aos] {
      opacity: 0.2;
      transform: translateY(20px);
      transition-property: opacity, transform;
      transition-duration: 600ms;
      transition-timing-function: ease-out;
    }
    [data-aos].aos-animate {
      opacity: 1;
      transform: translateY(0);
    }
  </style>
</head>

<body>
    <?php
include 'nav.php';?>

  <!-- Page Header -->
  <section class="page-header about-page-header" id="about-page-header">
    <div class="container">
      <h1 data-aos="fade-up">Our Story of Growth & Commitment</h1>
    </div>
  </section>

  <!-- Content Section -->
  <section class="content-section about-content-section" id="about-content-section">
    <div class="container">
      <div class="two-column">
        <div data-aos="fade-up" data-aos-delay="0">
          <h2 data-aos="fade-up" data-aos-delay="50">Our Journey</h2>
          <p data-aos="fade-up" data-aos-delay="100">
            Founded in 2011, MK Trading started as a small supplier and has
            grown into a comprehensive solution provider, driven by a passion
            for quality and service. What began as a modest operation has
            evolved into one of the region's most trusted names in hardware
            and building supplies.
          </p>
          <p data-aos="fade-up" data-aos-delay="150">
            Over the years, we have expanded our product range, strengthened
            our supplier relationships, and built a team of dedicated
            professionals committed to excellence. Our growth has been
            organic, fueled by customer satisfaction and word-of-mouth
            recommendations.
          </p>
        </div>
        <div data-aos="fade-up" data-aos-delay="200">
          <h2 data-aos="fade-up" data-aos-delay="250">Our Mission</h2>
          <p data-aos="fade-up" data-aos-delay="300">
            To empower builders, contractors, and homeowners with
            high-quality, reliable hardware and building materials, delivered
            with exceptional service. We believe that every project, whether
            big or small, deserves the best materials and support.
          </p>
          <p data-aos="fade-up" data-aos-delay="350">
            Our mission extends beyond just selling products – we aim to be a
            trusted partner in your success, providing expert guidance and
            solutions that help bring your visions to life.
          </p>
        </div>
      </div>

      <div style="margin-top: 3rem" data-aos="fade-up" data-aos-delay="0">
        <h2 data-aos="fade-up" data-aos-delay="50">Our Vision</h2>
        <p data-aos="fade-up" data-aos-delay="100">
          To be the most trusted and leading trading company in the region,
          known for integrity and an unparalleled product range. We envision a
          future where MK Trading Company is the first name that comes to mind
          when anyone thinks of quality hardware and building solutions.
        </p>
        <p data-aos="fade-up" data-aos-delay="150">
          We strive to continuously innovate, expand our offerings, and
          maintain the highest standards of customer service while staying
          true to our core values of quality, reliability, and
          customer-centricity.
        </p>
      </div>

      <div style="margin-top: 4rem" data-aos="fade-up" data-aos-delay="0">
        <h2 data-aos="fade-up" data-aos-delay="50">Why Choose Us?</h2>
        <div class="feature-grid">
          <div class="feature-item" data-feature="quality" data-aos="fade-up" data-aos-delay="100">
            <div class="feature-icon" data-aos="fade-up" data-aos-delay="150">✓</div>
            <div class="feature-number" data-aos="fade-up" data-aos-delay="200">100%</div>
            <h4 data-aos="fade-up" data-aos-delay="250">Quality Assured</h4>
            <p data-aos="fade-up" data-aos-delay="300">
              All our products meet stringent quality standards. We source
              from reputable manufacturers and conduct thorough quality checks
              to ensure you receive only the best.
            </p>
          </div>
          <div class="feature-item" data-feature="range" data-aos="fade-up" data-aos-delay="350">
            <div class="feature-icon" data-aos="fade-up" data-aos-delay="400">📦</div>
            <div class="feature-number" data-aos="fade-up" data-aos-delay="450">5000+</div>
            <h4 data-aos="fade-up" data-aos-delay="500">Wide Product Range</h4>
            <p data-aos="fade-up" data-aos-delay="550">
              A one-stop destination for all your needs. From basic hardware
              to specialized building materials, we have everything under one
              roof.
            </p>
          </div>
          <!-- <div class="feature-item" data-feature="support">
                        <div class="feature-icon">👥</div>
                        <div class="feature-number">24/7</div>
                        <h4>Expert Support</h4>
                        <p>Our knowledgeable team provides expert advice. Whether you need help selecting the right
                            product or technical guidance, we're here to help.</p>
                    </div> -->
          <div class="feature-item" data-feature="pricing" data-aos="fade-up" data-aos-delay="600">
            <div class="feature-icon" data-aos="fade-up" data-aos-delay="650">💰</div>
            <div class="feature-number" data-aos="fade-up" data-aos-delay="700">Best</div>
            <h4 data-aos="fade-up" data-aos-delay="750">Competitive Pricing</h4>
            <p data-aos="fade-up" data-aos-delay="800">
              We offer the best value for your investment. Our competitive
              pricing, combined with quality products, ensures you get maximum
              value.
            </p>
          </div>
        </div>
      </div>
    </div>
  </section>

<?php include 'footer.php';?>