<?php
include 'auth.php';
include 'db.php';
include 'adminhead.php';
include 'sidebar.php';

$success = '';
$error = '';

/* -------------------------
   DELETE CATEGORY
---------------------------*/
if (isset($_GET['delete_id'])) {
    $id = intval($_GET['delete_id']);
    $stmt = $conn->prepare("DELETE FROM categories WHERE id=?");
    $stmt->bind_param("i", $id);
    $success = $stmt->execute() ? "Category deleted successfully!" : "Failed to delete category: " . $stmt->error;
}

/* -------------------------
   ADD CATEGORY
---------------------------*/
if (isset($_POST['add_category'])) {
    $title = $_POST['title'];
    $stmt = $conn->prepare("INSERT INTO categories (title) VALUES (?)");
    $stmt->bind_param("s", $title);
    $success = $stmt->execute() ? "Category added successfully!" : "Failed to add category: " . $stmt->error;
}

/* -------------------------
   UPDATE CATEGORY
---------------------------*/
if (isset($_POST['update_category'])) {
    $id = intval($_POST['id']);
    $title = $_POST['title'];
    $stmt = $conn->prepare("UPDATE categories SET title=? WHERE id=?");
    $stmt->bind_param("si", $title, $id);
    $success = $stmt->execute() ? "Category updated successfully!" : "Failed to update category: " . $stmt->error;
}

/* -------------------------
   FETCH ALL CATEGORIES
---------------------------*/
$data = $conn->query("SELECT * FROM categories ORDER BY id DESC");
?>

<div class="page-wrapper">
    <div class="container-fluid">

        <h3 class="mb-4 fw-bold">Manage Categories</h3>

        <?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>
        <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>

        <!-- ADD CATEGORY FORM -->
        <div class="card mb-4">
            <div class="card-header">Add New Category</div>
            <div class="card-body">
                <form method="POST">
                    <div class="mb-3">
                        <label>Category Title</label>
                        <input type="text" name="title" class="form-control" required>
                    </div>
                    <button type="submit" name="add_category" class="btn btn-primary">Add Category</button>
                </form>
            </div>
        </div>

        <!-- CATEGORY TABLE -->
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="thead-dark">
                    <tr>
                        <th>#</th>
                        <th>Title</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i=1; while($row = $data->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['title']) ?></td>
                        <td>
                            <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#edit<?= $row['id'] ?>">Edit</button>
                            <a href="?delete_id=<?= $row['id'] ?>" onclick="return confirm('Delete this category?')" class="btn btn-danger btn-sm">Delete</a>
                        </td>
                    </tr>

                    <!-- EDIT MODAL -->
                    <div class="modal fade" id="edit<?= $row['id'] ?>" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <form method="POST">
                                    <div class="modal-header">
                                        <h5>Edit Category #<?= $row['id'] ?></h5>
                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                        <div class="form-group">
                                            <label>Category Title</label>
                                            <input type="text" name="title" class="form-control" value="<?= htmlspecialchars($row['title']) ?>" required>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" name="update_category" class="btn btn-success">Save Changes</button>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

    </div>
</div>

<?php include 'adminfoot.php'; ?>
