<?php
session_start();
include 'db.php';

$error = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    // Secure query
    $stmt = $conn->prepare("SELECT * FROM admin WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $admin = $result->fetch_assoc();

        if (password_verify($password, $admin['password'])) {
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_name'] = $admin['name'];
            $_SESSION['admin_email'] = $admin['email'];

            header("Location: dashboard.php");
            exit();
        } else {
            $error = "Invalid password!";
        }
    } else {
        $error = "No admin found with that email.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>Admin Login - MK Trading</title>

    <!-- Favicons -->
    <link href="asset/images/mk logo1.png" rel="icon">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com" rel="preconnect">
    <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="scss/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="scss/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
    <link href="scss/vendor/fontawesome-free/css/all.min.css" rel="stylesheet">

    <style>
    body {
        background-color: #f1f1f1;
        font-family: 'Poppins', sans-serif;
    }

    .login-card {
        width: 400px;
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.15);
        padding: 2rem;
    }

    .login-card h3 {
        font-weight: 600;
        color: #b30000;
        /* MK Trading Red */
    }

    .password-toggle {
        position: absolute;
        right: 15px;
        top: 38px;
        cursor: pointer;
        color: #666;
    }

    .login-logo {
        text-align: center;
        margin-bottom: 1rem;
    }

    .login-logo img {
        max-height: 80px;
    }

    .btn-primary {
        background-color: #b30000;
        border: none;
    }

    .btn-primary:hover {
        background-color: #8a0000;
    }
    </style>
</head>

<body class="d-flex align-items-center justify-content-center vh-100">

    <div class="login-card">
        <div class="login-logo">
            <img src="asset/images/mk logo1.png" alt="MK Trading Logo">
        </div>
        <h3 class="text-center mb-3">Admin Login</h3>

        <?php if ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="mb-3">
                <label class="form-label">Email</label>
                <input type="email" name="email" class="form-control" required placeholder="Enter admin email">
            </div>

            <div class="mb-3 position-relative">
                <label class="form-label">Password</label>
                <input type="password" id="password" name="password" class="form-control" required
                    placeholder="Enter password">
                <i class="bi bi-eye-slash password-toggle" id="togglePassword"></i>
            </div>

            <button type="submit" class="btn btn-primary w-100 mb-3">Login</button>
            <div class="text-center">
                <a href="forgot_password.php" class="text-decoration-none">Forgot Password?</a>
            </div>
        </form>
    </div>

    <!-- JS -->
    <script>
    const togglePassword = document.querySelector("#togglePassword");
    const passwordInput = document.querySelector("#password");

    togglePassword.addEventListener("click", function() {
        const type = passwordInput.type === "password" ? "text" : "password";
        passwordInput.type = type;
        this.classList.toggle("bi-eye");
        this.classList.toggle("bi-eye-slash");
    });
    </script>

    <script src="scss/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>

</html>