<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description"
    content="Explore MK Trading Company's comprehensive range of sectors: Sanitary Ware, Tiles, Electricals, Plumbing, and Hardware.">
  <title>Sectors - MK Trading Company</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/style.css">
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
  <style>
    /* Custom AOS animation to match requirements: opacity 0.2 initially */
    [data-aos] {
      opacity: 0.2;
      transform: translateY(20px);
      transition-property: opacity, transform;
      transition-duration: 600ms;
      transition-timing-function: ease-out;
    }

    [data-aos].aos-animate {
      opacity: 1;
      transform: translateY(0);
    }
  </style>
</head>

<body>
  <!-- Navigation -->
    <?php
include 'nav.php';?>

  <!-- Page Header -->
  <section class="page-header sectors-page-header" id="sectors-page-header">
    <div class="container">
      <h1 data-aos="fade-up">Our Product Sectors</h1>
      <p data-aos="fade-up" data-aos-delay="50">Comprehensive solutions for all your hardware and building needs</p>
    </div>
  </section>

   <!-- Featured Sectors -->
  <section class="featured-sectors">
    <div class="container">
      <h2 data-aos="fade-up">Our Key Sectors</h2>
      <div class="sectors-grid">
        <a href="products.php?sector_id=11" class="sector-card" data-aos="fade-up" data-aos-delay="0">
          <div class="sector-icon">
            <img src="assets/images/tiles.jpeg" alt="Tiles" data-aos="fade-up" data-aos-delay="50" />
          </div>
          <h3 data-aos="fade-up" data-aos-delay="100">Tiles</h3>
          <p data-aos="fade-up" data-aos-delay="150">Marble, Kitchen, Terrace, Bathroom Tiles</p>
        </a>
        <a href="products.php?sector_id=13" class="sector-card" data-aos="fade-up" data-aos-delay="100">
          <div class="sector-icon">
            <img src="assets/images/sanitary ware.jpeg" alt="Sanitary Ware" data-aos="fade-up" data-aos-delay="150" />
          </div>
          <h3 data-aos="fade-up" data-aos-delay="200">Sanitary Ware</h3>
          <p data-aos="fade-up" data-aos-delay="250">Basins, Water Closets, Showers</p>
        </a>
        <a href="products.php?sector_id=10" class="sector-card" data-aos="fade-up" data-aos-delay="200">
          <div class="sector-icon">
            <img src="assets/images/electrical.jpeg" alt="Electricals" data-aos="fade-up" data-aos-delay="250" />
          </div>
          <h3 data-aos="fade-up" data-aos-delay="300">Electricals</h3>
          <p data-aos="fade-up" data-aos-delay="350">Switches, Sockets, Fans, Sensors</p>
        </a>
        <a href="products.php?sector_id=9" class="sector-card" data-aos="fade-up" data-aos-delay="300">
          <div class="sector-icon">
            <img src="assets/images/plumbing.jpeg" alt="Plumbing" data-aos="fade-up" data-aos-delay="350" />
          </div>
          <h3 data-aos="fade-up" data-aos-delay="400">Plumbing</h3>
          <p data-aos="fade-up" data-aos-delay="450">Pipes, Fittings, Tanks, Valves</p>
        </a>
        <a href="products.php?sector_id=8" class="sector-card" data-aos="fade-up" data-aos-delay="400">
          <div class="sector-icon">
            <img src="assets/images/hard wares.jpeg" alt="Hardware Tools" data-aos="fade-up" data-aos-delay="450" />
          </div>
          <h3 data-aos="fade-up" data-aos-delay="500">Hardware Tools</h3>
          <p data-aos="fade-up" data-aos-delay="550">Power Tools, Hand Tools, Tool Kits</p>
        </a>
      </div>
    </div>
  </section>
 <?php include 'footer.php';?>