<?php
include 'auth.php';
include 'db.php';
include 'adminhead.php';
include 'sidebar.php';

$success = "";
$error = "";

/* -------------------------
   DELETE APPLICATION
---------------------------*/
if (isset($_GET['delete_id'])) {
    $id = intval($_GET['delete_id']);

    // First fetch the resume file to delete it
    $fileQ = $conn->query("SELECT resume FROM applications WHERE id=$id");
    $fileData = $fileQ->fetch_assoc();

    if ($fileData) {
        $resumePath = "uploads/resumes/" . $fileData['resume'];
        if (file_exists($resumePath)) {
            unlink($resumePath);
        }
    }

    // Now delete DB row
    $stmt = $conn->prepare("DELETE FROM applications WHERE id=?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        $success = "Application deleted successfully!";
    } else {
        $error = "Failed to delete application: " . $stmt->error;
    }
}

/* -------------------------
   FETCH ALL APPLICATIONS
---------------------------*/
$data = $conn->query("SELECT a.*, c.title AS job_title 
                      FROM applications a 
                      LEFT JOIN careers c ON a.job_id = c.id 
                      ORDER BY a.id DESC");
?>

<div class="page-wrapper">
    <div class="container-fluid">

        <h3 class="mb-4 fw-bold">Job Applications</h3>

        <?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>
        <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>

        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Job Title</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Resume</th>
                        <th>Applied At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i=1; while($row = $data->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['job_title']) ?></td>
                        <td><?= htmlspecialchars($row['name']) ?></td>
                        <td><?= htmlspecialchars($row['email']) ?></td>
                        <td><?= htmlspecialchars($row['phone']) ?></td>

                        <td>
                            <?php if (!empty($row['resume'])): ?>
                                <a href="uploads/resumes/<?= $row['resume'] ?>" target="_blank" class="btn btn-primary btn-sm">
                                    View Resume
                                </a>
                            <?php else: ?>
                                <span class="text-muted">No File</span>
                            <?php endif; ?>
                        </td>

                        <td><?= $row['created_at'] ?></td>

                        <td>
                            <a href="?delete_id=<?= $row['id'] ?>" 
                               onclick="return confirm('Delete this application?')" 
                               class="btn btn-danger btn-sm">
                                Delete
                            </a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

    </div>
</div>

<?php include 'adminfoot.php'; ?>
